/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.patreon.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.flemmli97.tenshilib.client.data.GeoAnimationManager;
import io.github.flemmli97.tenshilib.client.data.GeoModelManager;
import io.github.flemmli97.tenshilib.client.data.ReloadableCache;
import io.github.flemmli97.tenshilib.client.model.BedrockAnimations;
import io.github.flemmli97.tenshilib.client.model.ExtendedModel;
import io.github.flemmli97.tenshilib.client.model.ModelPartsContainer;
import io.github.flemmli97.tenshilib.client.render.RenderUtils;
import io.github.flemmli97.tenshilib.patreon.RenderLocation;
import io.github.flemmli97.tenshilib.patreon.client.model.PatreonModelData;
import net.minecraft.client.model.EntityModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class MeguHatModel
extends EntityModel<Player>
implements ExtendedModel,
PatreonModelData<Player> {
    public static final ResourceLocation MEGU_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"tenshilib", (String)"textures/model/megumin_hat.png");
    protected final ReloadableCache<ModelPartsContainer> model = GeoModelManager.getInstance().getModel(ResourceLocation.fromNamespaceAndPath((String)"tenshilib", (String)"megumin_hat"));
    protected final ReloadableCache<BedrockAnimations> anim = GeoAnimationManager.getInstance().getAnimation(ResourceLocation.fromNamespaceAndPath((String)"tenshilib", (String)"megumin_hat"));
    private RenderLocation location;

    public void setupAnim(Player entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.model.get().resetPoses();
        this.anim.get().doAnimation((ExtendedModel)this, "idle", entity.tickCount, RenderUtils.getPartialTicks((Entity)entity));
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        if (RenderLocation.isHead(this.location)) {
            poseStack.translate(0.0, 0.1, 0.0);
        }
        this.model.get().getRoot().render(poseStack, buffer, packedLight, packedOverlay, color);
    }

    @Override
    public ModelPartsContainer getModel() {
        return this.model.get();
    }

    @Override
    public void setRenderLocation(RenderLocation loc) {
        this.location = loc;
    }

    @Override
    public ResourceLocation texture(Player entity) {
        return MEGU_TEXTURE;
    }
}

