/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.calendar;

import net.minecraft.ChatFormatting;

public enum Season {
    SPRING(ChatFormatting.RED, "spring"),
    SUMMER(ChatFormatting.DARK_GREEN, "summer"),
    AUTUMN(ChatFormatting.GOLD, "autumn"),
    WINTER(ChatFormatting.BLUE, "winter");

    public static final String PREFIX = "runecraftory.season.";
    private final ChatFormatting color;
    private final String translationKey;

    private Season(ChatFormatting color, String key) {
        this.color = color;
        this.translationKey = PREFIX + key;
    }

    public static Season nextSeason(Season season) {
        return switch (season.ordinal()) {
            case 2 -> WINTER;
            case 0 -> SUMMER;
            case 1 -> AUTUMN;
            default -> SPRING;
        };
    }

    public ChatFormatting getColor() {
        return this.color;
    }

    public String translationKey() {
        return this.translationKey;
    }
}

