/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.datapack;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.calendar.Season;
import io.github.flemmli97.tenshilib.common.utils.CodecUtils;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;

public class CropProperties {
    public static final Codec<CropProperties> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("growth").forGetter(CropProperties::growth), (App)Codec.INT.fieldOf("max_drops").forGetter(CropProperties::maxDrops), (App)Codec.BOOL.fieldOf("regrowable").forGetter(CropProperties::regrowable), (App)BuiltInRegistries.BLOCK.byNameCodec().optionalFieldOf("giant_crop").forGetter(CropProperties::getGiantVersion), (App)CodecUtils.stringEnumCodec(Season.class, (Enum)Season.SPRING).listOf().fieldOf("best_season").forGetter(d -> List.copyOf(d.bestSeasons)), (App)CodecUtils.stringEnumCodec(Season.class, (Enum)Season.SPRING).listOf().fieldOf("bad_season").forGetter(d -> List.copyOf(d.badSeasons))).apply((Applicative)instance, CropProperties::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, CropProperties> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, CropProperties>(){

        public CropProperties decode(RegistryFriendlyByteBuf buf) {
            return new CropProperties(buf.readInt(), buf.readInt(), buf.readBoolean(), (Optional)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.BLOCK)).decode((Object)buf), buf.readEnumSet(Season.class), buf.readEnumSet(Season.class));
        }

        public void encode(RegistryFriendlyByteBuf buf, CropProperties props) {
            buf.writeInt(props.growth());
            buf.writeInt(props.maxDrops());
            buf.writeBoolean(props.regrowable());
            ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.BLOCK)).encode((Object)buf, props.getGiantVersion());
            buf.writeEnumSet(props.bestSeasons, Season.class);
            buf.writeEnumSet(props.badSeasons, Season.class);
        }
    };
    private final EnumSet<Season> bestSeasons = EnumSet.noneOf(Season.class);
    private final EnumSet<Season> badSeasons = EnumSet.noneOf(Season.class);
    private final int growth;
    private final int maxDrops;
    private final boolean regrowable;
    private final Optional<Block> giantVersion;
    private final List<Component> translationTexts;

    public CropProperties(int growth, int maxDrops, boolean regrowable, Optional<Block> giantVersion, Collection<Season> bestSeasons, Collection<Season> badSeasons) {
        this.growth = growth;
        this.maxDrops = maxDrops;
        this.giantVersion = giantVersion;
        this.regrowable = regrowable;
        this.bestSeasons.addAll(bestSeasons);
        this.badSeasons.addAll(badSeasons);
        this.translationTexts = this.generateText();
    }

    private List<Component> generateText() {
        ImmutableList.Builder list = ImmutableList.builder();
        if (!this.bestSeasons.isEmpty()) {
            MutableComponent txt = null;
            for (Season season : this.bestSeasons) {
                if (txt == null) {
                    txt = Component.translatable((String)season.translationKey()).withStyle(season.getColor());
                    continue;
                }
                txt.append((Component)Component.literal((String)"/").withStyle(ChatFormatting.GRAY)).append((Component)Component.translatable((String)season.translationKey()).withStyle(season.getColor()));
            }
            list.add((Object)Component.translatable((String)"runecraftory.tooltip.crops.season.best", (Object[])new Object[]{txt}).withStyle(ChatFormatting.GRAY));
        }
        EnumSet<Season> badSeasons = EnumSet.copyOf(this.badSeasons);
        badSeasons.removeAll(this.bestSeasons);
        if (!badSeasons.isEmpty()) {
            MutableComponent txt = null;
            for (Season season : badSeasons) {
                if (txt == null) {
                    txt = Component.translatable((String)season.translationKey()).withStyle(season.getColor());
                    continue;
                }
                txt.append((Component)Component.literal((String)"/").withStyle(ChatFormatting.GRAY)).append((Component)Component.translatable((String)season.translationKey()).withStyle(season.getColor()));
            }
            list.add((Object)Component.translatable((String)"runecraftory.tooltip.crops.season.bad", (Object[])new Object[]{txt}).withStyle(ChatFormatting.GRAY));
        }
        MutableComponent growth = Component.translatable((String)"runecraftory.tooltip.crops.growth", (Object[])new Object[]{this.growth()}).withStyle(ChatFormatting.GOLD);
        MutableComponent mutableComponent = Component.translatable((String)"runecraftory.tooltip.crops.harvested", (Object[])new Object[]{this.maxDrops()}).withStyle(ChatFormatting.GOLD);
        if (this.regrowable()) {
            MutableComponent regrowable = Component.translatable((String)"runecraftory.tooltip.crops.regrowable").withStyle(ChatFormatting.GREEN);
            list.add((Object)Component.translatable((String)"runecraftory.tooltip.crops.entry.3", (Object[])new Object[]{growth, mutableComponent, regrowable}));
        } else {
            list.add((Object)Component.translatable((String)"runecraftory.tooltip.crops.entry.2", (Object[])new Object[]{growth, mutableComponent}));
        }
        return list.build();
    }

    public Set<Season> bestSeasons() {
        return ImmutableSet.copyOf(this.bestSeasons);
    }

    public Set<Season> badSeasons() {
        return ImmutableSet.copyOf(this.badSeasons);
    }

    public int growth() {
        return this.growth;
    }

    public int maxDrops() {
        return this.maxDrops;
    }

    public boolean regrowable() {
        return this.regrowable;
    }

    public Optional<Block> getGiantVersion() {
        return this.giantVersion;
    }

    public float seasonMultiplier(Season season) {
        if (this.bestSeasons.contains((Object)season)) {
            return 1.5f;
        }
        if (this.badSeasons.contains((Object)season)) {
            return 0.6666667f;
        }
        return 1.0f;
    }

    public List<Component> texts() {
        return this.translationTexts;
    }

    public String toString() {
        return "[BestSeasons:" + String.valueOf(this.bestSeasons) + ";BadSeasons:" + String.valueOf(this.badSeasons) + ";Growth:" + this.growth + ";Drops:" + this.maxDrops + ";Regrowable:" + this.regrowable + "]";
    }

    public static class Builder {
        private final EnumSet<Season> bestSeason = EnumSet.noneOf(Season.class);
        private final EnumSet<Season> badSeason = EnumSet.noneOf(Season.class);
        private final int growth;
        private final int maxDrops;
        private final boolean regrowable;
        private Block giantVersion;

        public Builder(int growth, int maxDrops, boolean regrowable) {
            this.growth = growth;
            this.maxDrops = maxDrops;
            this.regrowable = regrowable;
        }

        public Builder addGoodSeason(Season season) {
            this.bestSeason.add(season);
            return this;
        }

        public Builder addBadSeason(Season season) {
            this.badSeason.add(season);
            return this;
        }

        public Builder withGiantVersion(Block giantVersion) {
            this.giantVersion = giantVersion;
            return this;
        }

        public CropProperties build() {
            return new CropProperties(this.growth, this.maxDrops, this.regrowable, Optional.ofNullable(this.giantVersion), this.bestSeason, this.badSeason);
        }
    }
}

