/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.datapack;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.Optional;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class EntityRideActionCosts {
    public static final Codec<EntityRideActionCosts> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RideActionCost.CODEC.fieldOf("command_1").forGetter(d -> d.command1), (App)RideActionCost.CODEC.optionalFieldOf("command_2").forGetter(d -> Optional.ofNullable(d.command2)), (App)RideActionCost.CODEC.optionalFieldOf("command_3").forGetter(d -> Optional.ofNullable(d.command3)), (App)RideActionCost.CODEC.optionalFieldOf("command_4").forGetter(d -> Optional.ofNullable(d.command4))).apply((Applicative)instance, (c1, c2, c3, c4) -> new EntityRideActionCosts((RideActionCost)c1, c2.orElse(null), c3.orElse(null), c4.orElse(null))));
    public static final EntityRideActionCosts DEFAULT = new Builder(0.5f, true).build();
    private final RideActionCost command1;
    private final RideActionCost command2;
    private final RideActionCost command3;
    private final RideActionCost command4;

    private EntityRideActionCosts(RideActionCost command1, RideActionCost command2, RideActionCost command3, RideActionCost command4) {
        this.command1 = command1;
        this.command2 = command2;
        this.command3 = command3;
        this.command4 = command4;
    }

    public boolean canRun(int command, Entity entity, @Nullable Spell spell) {
        if (!(entity instanceof ServerPlayer)) {
            return true;
        }
        ServerPlayer player = (ServerPlayer)entity;
        RideActionCost cost = this.getCost(command);
        PlayerData data = Platform.INSTANCE.getPlayerData((Player)player);
        if (spell == null || !cost.multiplier) {
            if (cost.multiplier) {
                return true;
            }
            if (!LevelCalc.useRP(data, cost.cost, false, 0.0f, false, new Skills[0])) {
                EntityUtils.playSoundForPlayer(player, (SoundEvent)RuneCraftorySounds.GENERIC_DENY.get(), 1.0f, 1.0f);
                return false;
            }
            return true;
        }
        return Spell.tryUseWithCost((LivingEntity)player, ItemStack.EMPTY, spell, cost.cost);
    }

    private RideActionCost getCost(int command) {
        RideActionCost cost;
        switch (command) {
            case 3: {
                RideActionCost rideActionCost = this.command4;
                break;
            }
            case 2: {
                RideActionCost rideActionCost = this.command3;
                break;
            }
            case 1: {
                RideActionCost rideActionCost = this.command2;
                break;
            }
            default: {
                RideActionCost rideActionCost = cost = this.command1;
            }
        }
        if (cost == null) {
            cost = this.command1;
        }
        return cost;
    }

    record RideActionCost(float cost, boolean multiplier) {
        public static final Codec<RideActionCost> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("cost").forGetter(d -> Float.valueOf(d.cost)), (App)Codec.BOOL.fieldOf("multiplier").forGetter(d -> d.multiplier)).apply((Applicative)instance, RideActionCost::new));
    }

    public static class Builder {
        private final RideActionCost command1;
        private RideActionCost command2;
        private RideActionCost command3;
        private RideActionCost command4;

        public Builder() {
            this(0.0f, false);
        }

        public Builder(float cost, boolean multiplier) {
            this.command1 = new RideActionCost(cost, multiplier);
        }

        public Builder secondCost(float cost, boolean multiplier) {
            this.command2 = new RideActionCost(cost, multiplier);
            return this;
        }

        public Builder thirdCost(float cost, boolean multiplier) {
            this.command3 = new RideActionCost(cost, multiplier);
            return this;
        }

        public Builder fourthCost(float cost, boolean multiplier) {
            this.command4 = new RideActionCost(cost, multiplier);
            return this;
        }

        public EntityRideActionCosts build() {
            return new EntityRideActionCosts(this.command1, this.command2, this.command3, this.command4);
        }
    }
}

