/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.datapack;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.common.utils.CodecHelper;
import io.github.flemmli97.runecraftory.common.utils.HolderUtils;
import io.github.flemmli97.tenshilib.common.utils.CodecUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public record ShopItemProperties(ItemStack stack, UnlockType unlockType, Optional<EntityPredicate> predicate) {
    public static final Codec<TagKey<Item>> TAG_CODEC = Codec.STRING.flatXmap(r -> {
        if (r.startsWith("#")) {
            return DataResult.success((Object)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)r.substring(1))));
        }
        return DataResult.error(() -> "Not a tag value" + r);
    }, l -> DataResult.success((Object)("#" + String.valueOf(l.location()))));
    public static final Codec<MultiItemValue> MULTI_ITEM_VALUE_CODEC = Codec.either(TAG_CODEC, CodecHelper.listOrSingle(CodecHelper.ITEM_OR_STACK)).xmap(MultiItemValue::new, v -> v.tag != null ? Either.left(v.tag) : Either.right(v.items));
    public static final Codec<IntermediaryShopItem> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MULTI_ITEM_VALUE_CODEC.fieldOf("item").forGetter(IntermediaryShopItem::items), (App)CodecUtils.stringEnumCodec(UnlockType.class, null).fieldOf("unlock_type").forGetter(IntermediaryShopItem::unlockType), (App)EntityPredicate.CODEC.optionalFieldOf("predicate").forGetter(IntermediaryShopItem::predicate)).apply((Applicative)instance, IntermediaryShopItem::new));

    public static List<ShopItemProperties> from(HolderLookup.Provider provider, IntermediaryShopItem item) {
        ArrayList<ShopItemProperties> list = new ArrayList<ShopItemProperties>();
        item.items().getContents(provider).forEach(stack -> list.add(new ShopItemProperties((ItemStack)stack, item.unlockType, item.predicate)));
        return list;
    }

    public static enum UnlockType {
        DEFAULT,
        ALWAYS,
        NEEDS_SHIPPING;

    }

    public record IntermediaryShopItem(MultiItemValue items, UnlockType unlockType, Optional<EntityPredicate> predicate) {
        public IntermediaryShopItem(MultiItemValue items, UnlockType unlockType) {
            this(items, unlockType, Optional.empty());
        }

        public boolean isTag() {
            return this.items.tag != null;
        }
    }

    public static class MultiItemValue {
        private final TagKey<Item> tag;
        private final List<ItemStack> items;

        private MultiItemValue(Either<TagKey<Item>, List<ItemStack>> either) {
            this.tag = either.left().orElse(null);
            this.items = either.right().orElse(null);
        }

        public MultiItemValue(TagKey<Item> tag) {
            this.tag = tag;
            this.items = null;
        }

        public MultiItemValue(List<ItemStack> list) {
            this.tag = null;
            this.items = list;
        }

        public static MultiItemValue of(Item ... item) {
            return new MultiItemValue(Arrays.stream(item).map(ItemStack::new).toList());
        }

        public List<ItemStack> getContents(HolderLookup.Provider provider) {
            if (this.tag != null) {
                return HolderUtils.expandTag(provider, Registries.ITEM, this.tag, ItemStack::new);
            }
            return this.items;
        }
    }
}

