/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.datapack.provider;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.runecraftory.common.datapack.manager.FarmlandHoeTileActionManager;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;

public abstract class FarmlandHoeTileActionProvider
implements DataProvider {
    private final Map<ResourceLocation, FarmlandHoeTileActionManager.Data> data = new HashMap<ResourceLocation, FarmlandHoeTileActionManager.Data>();
    private final PackOutput packOutput;
    private final String modid;
    protected final CompletableFuture<HolderLookup.Provider> provider;
    private final Function<Item, ResourceLocation> keyExtractor;

    public FarmlandHoeTileActionProvider(PackOutput packOutput, String modid, CompletableFuture<HolderLookup.Provider> provider) {
        this(packOutput, modid, provider, item -> item.builtInRegistryHolder().key().location());
    }

    public FarmlandHoeTileActionProvider(PackOutput packOutput, String modid, CompletableFuture<HolderLookup.Provider> provider, Function<Item, ResourceLocation> keyExtractor) {
        this.packOutput = packOutput;
        this.modid = modid;
        this.provider = provider;
        this.keyExtractor = keyExtractor;
    }

    protected abstract void add(HolderLookup.Provider var1);

    public CompletableFuture<?> run(CachedOutput cache) {
        return ((CompletableFuture)this.provider.thenApply(provider -> {
            this.add((HolderLookup.Provider)provider);
            return provider;
        })).thenCompose(provider -> {
            RegistryOps ops = provider.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
            ImmutableList.Builder futures = new ImmutableList.Builder();
            this.data.forEach((arg_0, arg_1) -> this.lambda$run$2((DynamicOps)ops, futures, cache, arg_0, arg_1));
            return CompletableFuture.allOf((CompletableFuture[])futures.build().toArray(CompletableFuture[]::new));
        });
    }

    public String getName() {
        return "Fertilizer Data for " + this.modid;
    }

    public void add(ItemLike item, int amount) {
        this.add(this.keyExtractor.apply(item.asItem()).getPath(), (ItemLike)item.asItem(), amount);
    }

    public void add(String id, ItemLike item, int amount) {
        ResourceLocation res = ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)id);
        this.data.put(res, new FarmlandHoeTileActionManager.Data(item.asItem(), amount));
    }

    private /* synthetic */ void lambda$run$2(DynamicOps ops, ImmutableList.Builder futures, CachedOutput cache, ResourceLocation res, FarmlandHoeTileActionManager.Data data) {
        Path path = this.packOutput.getOutputFolder(PackOutput.Target.DATA_PACK).resolve(res.getNamespace() + "/" + FarmlandHoeTileActionManager.DIRECTORY + "/" + res.getPath() + ".json");
        JsonElement obj = (JsonElement)FarmlandHoeTileActionManager.Data.CODEC.encodeStart(ops, (Object)data).getOrThrow();
        futures.add((Object)DataProvider.saveStable((CachedOutput)cache, (JsonElement)obj, (Path)path));
    }
}

