/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.registry;

import io.github.flemmli97.runecraftory.api.datapack.ItemStat;
import io.github.flemmli97.runecraftory.common.components.ArmorEffectData;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryDataComponentTypes;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class ArmorEffect {
    public static boolean hasArmorEffect(LivingEntity entity, Holder<ArmorEffect> effect) {
        return Platform.INSTANCE.getEntityData(entity).hasArmorFlag(effect);
    }

    public static void runArmorEffectFor(ItemStack stack, Consumer<ArmorEffect> cons) {
        if (stack.isEmpty()) {
            return;
        }
        if (stack.has((DataComponentType)RuneCraftoryDataComponentTypes.ARMOR_EFFECT.get())) {
            ((ArmorEffectData)stack.get((DataComponentType)RuneCraftoryDataComponentTypes.ARMOR_EFFECT.get())).triggerEvent(stack, cons);
            return;
        }
        DataPackHandler.INSTANCE.itemStatManager().get(stack.getItem()).flatMap(ItemStat::getArmorEffect).ifPresent(eff -> cons.accept((ArmorEffect)eff.value()));
    }

    public boolean canBeAppliedTo(ItemStack stack) {
        return true;
    }

    public void onStep(LivingEntity entity, ItemStack stack) {
    }

    public void onTick(LivingEntity entity, ItemStack stack) {
    }

    public void onEquip(LivingEntity entity, ItemStack stack) {
    }

    public void onRemove(LivingEntity entity, ItemStack stack) {
    }
}

