/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client;

import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.client.gui.GuiUtils;
import io.github.flemmli97.runecraftory.common.config.ClientConfig;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import org.jetbrains.annotations.Nullable;

public class BossBarTracker {
    private static final Map<ResourceLocation, ClientBossBarType> BOSS_BARS = new HashMap<ResourceLocation, ClientBossBarType>();
    private static final Map<UUID, BossBarData> ACTIVE_BOSS_BARS = new HashMap<UUID, BossBarData>();
    private static final Map<UUID, BossSoundInstance> ACTIVE_BOSS_BGM = new HashMap<UUID, BossSoundInstance>();
    private static SoundInstance activeMusic;
    private static int lastPlay;
    private static int tick;

    public static void registerCustomBossbarType(ResourceLocation id, ClientBossBarType type) {
        BOSS_BARS.put(id, type);
    }

    public static void register() {
        BossBarTracker.registerBossBarFor(RuneCraftoryEntities.CHIMERA.getID());
        BossBarTracker.registerBossBarFor(RuneCraftoryEntities.RAFFLESIA.getID());
        BossBarTracker.registerBossBarFor(RuneCraftoryEntities.GRIMOIRE.getID());
        BossBarTracker.registerBossBarFor(RuneCraftoryEntities.DEAD_TREE.getID());
        BossBarTracker.registerBossBarFor(RuneCraftoryEntities.RACCOON.getID());
        BossBarTracker.registerBossBarFor(RuneCraftoryEntities.SKELEFANG.getID());
        BossBarTracker.registerBossBarFor(RuneCraftoryEntities.AMBROSIA.getID());
        BossBarTracker.registerBossBarFor(RuneCraftoryEntities.THUNDERBOLT.getID());
        BossBarTracker.registerBossBarFor(RuneCraftoryEntities.MARIONETTA.getID());
        BossBarTracker.registerBossBarFor(RuneCraftoryEntities.HANDONETTA.getID());
        BossBarTracker.registerBossBarFor(RuneCraftoryEntities.SANO_AND_UNO.getID());
        BossBarTracker.registerBossBarFor(RuneCraftoryEntities.SARCOPHAGUS.getID());
    }

    private static void registerBossBarFor(ResourceLocation id) {
        BossBarTracker.registerCustomBossbarType(id, new ClientBossBarType(new BossbarTexture(RuneCraftory.modRes(String.format("bossbar/%s_bossbar", id.getPath())), 198, 15, 0, 0), new BossbarTexture(RuneCraftory.modRes(String.format("bossbar/%s_bossbar_progress", id.getPath())), 198, 15, 0, 0), new BossbarTexture(RuneCraftory.modRes(String.format("bossbar/%s_bossbar_overlay", id.getPath())), 198, 15, 0, 0)));
    }

    public static void tickSounds() {
        if (Minecraft.getInstance().level == null) {
            ACTIVE_BOSS_BGM.clear();
        }
        ++tick;
        ACTIVE_BOSS_BGM.values().removeIf(inst -> {
            if (inst.isStopped()) {
                BossBarTracker.stopMusic(inst);
                return true;
            }
            return false;
        });
    }

    public static void addActiveBossbar(UUID id, UUID musicID, ResourceLocation type, SoundEvent music) {
        BossBarData old = ACTIVE_BOSS_BARS.get(id);
        if (old != null) {
            BossSoundInstance sound;
            if (!(old.music == null || (sound = ACTIVE_BOSS_BGM.get(old.music)) == null || music != null && sound.getLocation().equals((Object)music.getLocation()))) {
                sound.removeBossBar(id, true);
                BossBarTracker.createSound(musicID, music).ifPresent(bgm -> {
                    old.music = musicID;
                    ACTIVE_BOSS_BGM.put(musicID, (BossSoundInstance)((Object)bgm));
                    BossBarTracker.playMusic(bgm);
                });
            }
            return;
        }
        BossSoundInstance inst = ACTIVE_BOSS_BGM.get(musicID);
        if (inst != null) {
            inst.linkBossBar(id, false);
        } else {
            BossBarTracker.createSound(musicID, music).ifPresent(instance -> {
                instance.linkBossBar(id, true);
                BossBarTracker.playMusic(instance);
                ACTIVE_BOSS_BGM.put(musicID, (BossSoundInstance)((Object)instance));
            });
        }
        BossBarData data = new BossBarData(type, musicID);
        ACTIVE_BOSS_BARS.put(id, data);
    }

    public static void updateMusic(UUID id, UUID musicID, SoundEvent sound) {
        BossSoundInstance bgm = ACTIVE_BOSS_BGM.get(musicID);
        if (bgm != null) {
            if (sound == null) {
                bgm.removeBossBar(id, true);
            } else {
                boolean empty = bgm.instances.isEmpty();
                bgm.linkBossBar(id, false);
                if (empty) {
                    BossBarTracker.playMusic(bgm);
                }
            }
        } else if (sound != null) {
            BossBarTracker.createSound(musicID, sound).ifPresent(instance -> {
                instance.linkBossBar(id, true);
                BossBarTracker.playMusic(instance);
                ACTIVE_BOSS_BGM.put(musicID, (BossSoundInstance)((Object)instance));
            });
        }
    }

    public static void removeActiveBossbar(UUID id, boolean immediate) {
        BossBarData data = ACTIVE_BOSS_BARS.remove(id);
        if (data != null && data.music != null) {
            BossSoundInstance sound = ACTIVE_BOSS_BGM.get(data.music);
            if (sound == null) {
                return;
            }
            sound.removeBossBar(id, immediate);
        }
    }

    public static Optional<BossSoundInstance> createSound(UUID id, SoundEvent sound) {
        if (sound == null || !ClientConfig.bossMusic) {
            return Optional.empty();
        }
        return Optional.of(new BossSoundInstance(id, sound, SoundSource.RECORDS, 1.0f, 1.0f, ClientConfig.bossMusicFadeDelay));
    }

    private static void playMusic(BossSoundInstance sound) {
        if (lastPlay == tick) {
            return;
        }
        lastPlay = tick;
        if (activeMusic != null) {
            Minecraft.getInstance().getSoundManager().stop(activeMusic);
        }
        Minecraft.getInstance().getMusicManager().stopPlaying();
        Minecraft.getInstance().getSoundManager().play((SoundInstance)sound);
        activeMusic = sound;
    }

    private static void stopMusic(BossSoundInstance sound) {
        Minecraft.getInstance().getSoundManager().stop((SoundInstance)sound);
        if (activeMusic == sound) {
            ACTIVE_BOSS_BGM.values().stream().filter(bgm -> bgm != sound && !bgm.instances.isEmpty()).findFirst().ifPresent(bgm -> {
                Minecraft.getInstance().getSoundManager().play((SoundInstance)bgm);
                activeMusic = bgm;
            });
        }
    }

    public static boolean hasActiveMusic() {
        return activeMusic != null;
    }

    public static int tryRenderCustomBossbar(GuiGraphics graphics, int x, int y, BossEvent bossEvent, boolean withName) {
        ClientBossBarType type;
        if (!ClientConfig.customBossbars) {
            return -1;
        }
        BossBarData data = ACTIVE_BOSS_BARS.get(bossEvent.getId());
        if (data != null && (type = BOSS_BARS.get(data.type)) != null) {
            return type.renderFrom(graphics, x, y, bossEvent, withName);
        }
        return -1;
    }

    public record ClientBossBarType(BossbarTexture background, BossbarTexture progress, BossbarTexture overlay) {
        private static final int BAR_WIDTH = 182;

        public int renderFrom(GuiGraphics graphics, int x, int y, BossEvent bossEvent, boolean withName) {
            Minecraft mc = Minecraft.getInstance();
            int diff = (this.background().width() - 182) / 2;
            graphics.blitSprite(this.background().texture(), x -= diff, y, this.background().width(), this.background().height());
            int overlayWidth = (int)(bossEvent.getProgress() * 182.0f);
            GuiUtils.drawBorderedBar(graphics, this.progress().texture(), x, y, this.progress().width(), this.progress().height(), overlayWidth, 8, 5);
            graphics.blitSprite(this.overlay().texture(), x, y, this.overlay().width(), this.overlay().height());
            if (withName) {
                int screenX = mc.getWindow().getGuiScaledWidth();
                Component component = bossEvent.getName();
                int len = mc.font.width((FormattedText)component);
                int txtX = screenX / 2 - len / 2;
                Font font = mc.font;
                Objects.requireNonNull(mc.font);
                graphics.drawString(font, component, txtX, y - 9, 0xFFFFFF);
            }
            Objects.requireNonNull(mc.font);
            return 9 + this.background().height() + 1;
        }
    }

    public record BossbarTexture(ResourceLocation texture, int width, int height, int offsetX, int offsetY) {
    }

    public static class BossBarData {
        public final ResourceLocation type;
        public UUID music;

        public BossBarData(ResourceLocation type, UUID music) {
            this.type = type;
            this.music = music;
        }
    }

    public static class BossSoundInstance
    extends AbstractTickableSoundInstance {
        public final UUID id;
        private final int fadeTime;
        private final float defaultVol;
        private final float volDecrease;
        private int tick = 1;
        private boolean fadeAway;
        private boolean adjustingVolume;
        private final Set<UUID> instances = new HashSet<UUID>();

        public BossSoundInstance(UUID id, SoundEvent soundEvent, SoundSource soundSource, float volume, float pitch, int fadeTime) {
            super(soundEvent, soundSource, SoundInstance.createUnseededRandom());
            this.id = id;
            this.volume = volume;
            this.pitch = pitch;
            this.fadeTime = fadeTime;
            this.defaultVol = Mth.clamp((float)(volume * BossSoundInstance.getVolume(soundSource)), (float)0.0f, (float)1.0f);
            this.volDecrease = 1.0f / (float)this.fadeTime;
            this.looping = true;
            this.relative = true;
        }

        private static float getVolume(@Nullable SoundSource category) {
            if (category == null || category == SoundSource.MASTER) {
                return 1.0f;
            }
            return Minecraft.getInstance().options.getSoundSourceVolume(category);
        }

        public void linkBossBar(UUID barId, boolean init) {
            this.instances.add(barId);
            if (!init) {
                this.setFadeState(true);
            }
        }

        public void removeBossBar(UUID barId, boolean immediate) {
            this.instances.remove(barId);
            if (this.instances.isEmpty()) {
                if (immediate) {
                    this.stop();
                } else {
                    this.setFadeState(false);
                }
            }
        }

        private void setFadeState(boolean fadeAway) {
            this.fadeAway = fadeAway;
            this.tick = Mth.clamp((int)this.tick, (int)0, (int)this.fadeTime);
            this.adjustingVolume = true;
        }

        public boolean done() {
            return this.tick > this.fadeTime || this.tick < 0;
        }

        public void tick() {
            if (!this.adjustingVolume) {
                if (this.instances.isEmpty()) {
                    this.stop();
                }
                return;
            }
            boolean done = this.done();
            this.tick = this.fadeAway ? --this.tick : ++this.tick;
            this.volume = this.defaultVol * Mth.clamp((float)(1.0f - this.volDecrease * (float)this.tick), (float)0.0f, (float)1.0f);
            if (done) {
                this.adjustingVolume = false;
            }
        }
    }
}

