/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.client.gui.GuiUtils;
import io.github.flemmli97.runecraftory.client.gui.widgets.SpriteResources;
import io.github.flemmli97.runecraftory.common.entities.utils.IBaseMob;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.mixinhelper.GuiGraphicsExtension;
import io.github.flemmli97.tenshilib.client.render.RenderUtils;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;

public abstract class CompanionGui<T extends LivingEntity>
extends Screen {
    protected static final ResourceLocation TEXTURE_PATH = RuneCraftory.modRes("textures/gui/misc/companion_gui.png");
    public static final ResourceLocation HEALTH = RuneCraftory.modRes("widget/health_bar");
    public static final ResourceLocation EXPERIENCE = RuneCraftory.modRes("widget/experience_bar");
    private final int textureX = 190;
    private final int textureY = 117;
    private final int sizeY = this.textureY + 70;
    private final Component levelTxt = Component.translatable((String)"runecraftory.gui.level");
    protected int leftPos;
    protected int topPos;
    protected final T entity;

    public CompanionGui(T entity) {
        super(entity.getDisplayName());
        this.entity = entity;
    }

    protected void init() {
        super.init();
        this.leftPos = (this.width - this.textureX) / 2;
        this.topPos = (this.height - this.sizeY) / 2;
        this.buttons();
    }

    protected void renderBlurredBackground(float partialTick) {
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(graphics, mouseX, mouseY, partialTick);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture());
        graphics.blit(RuneCraftory.modRes("textures/gui/misc/companion_gui.png"), this.leftPos, this.topPos, 0, 0, this.textureX, this.textureY);
        int iconX = 86;
        int iconY = 46;
        graphics.blitSprite(SpriteResources.ATTACK_ICON, this.leftPos + iconX, this.topPos + iconY, 8, 8);
        graphics.blitSprite(SpriteResources.DEFENCE_ICON, this.leftPos + iconX, this.topPos + iconY + 13, 8, 8);
        graphics.blitSprite(SpriteResources.MAGIC_ATTACK_ICON, this.leftPos + iconX, this.topPos + iconY + 26, 8, 8);
        graphics.blitSprite(SpriteResources.MAGIC_DEFENCE_ICON, this.leftPos + iconX, this.topPos + iconY + 39, 8, 8);
        graphics.blitSprite(SpriteResources.FRIENDSHIP_ICON, this.leftPos + iconX, this.topPos + iconY + 52, 8, 8);
        int healthWidth = Math.min(100, (int)((double)(this.entity.getHealth() / this.entity.getMaxHealth()) * 100.0));
        int exp = Math.min(100, (int)((double)((IBaseMob)this.entity).xpLevel().getProgress() * 100.0));
        int barX = 80;
        GuiUtils.drawBorderedBar(graphics, HEALTH, this.leftPos + barX, this.topPos + 18, 102, 11, healthWidth, 1, 1);
        GuiGraphicsExtension.drawCenteredString(graphics, this.font, (int)this.entity.getHealth() + "/" + (int)this.entity.getMaxHealth(), (float)(this.leftPos + barX) + 51.5f, (float)(this.topPos + 20), 0xFFFFFF, false);
        GuiUtils.drawBorderedBar(graphics, EXPERIENCE, this.leftPos + barX, this.topPos + 32, 102, 11, exp, 1, 1);
        graphics.drawString(this.font, this.levelTxt, this.leftPos + 83, this.topPos + 34, 0, false);
        GuiGraphicsExtension.drawRightAlignedString(graphics, this.font, "" + ((IBaseMob)this.entity).xpLevel().getLevel(), (float)(this.leftPos + barX + 97), (float)(this.topPos + 34), 0, false);
        int statX = 177;
        int statY = 46;
        GuiGraphicsExtension.drawRightAlignedString(graphics, this.font, "" + (int)CombatUtils.getAttributeValue(this.entity, (Holder<Attribute>)Attributes.ATTACK_DAMAGE), (float)(this.leftPos + statX), (float)(this.topPos + statY), 0, false);
        GuiGraphicsExtension.drawRightAlignedString(graphics, this.font, "" + (int)CombatUtils.getAttributeValue(this.entity, (Holder<Attribute>)RuneCraftoryAttributes.DEFENCE.asHolder()), (float)(this.leftPos + statX), (float)(this.topPos + statY + 13), 0, false);
        GuiGraphicsExtension.drawRightAlignedString(graphics, this.font, "" + (int)CombatUtils.getAttributeValue(this.entity, (Holder<Attribute>)RuneCraftoryAttributes.MAGIC_ATTACK.asHolder()), (float)(this.leftPos + statX), (float)(this.topPos + statY + 26), 0, false);
        GuiGraphicsExtension.drawRightAlignedString(graphics, this.font, "" + (int)CombatUtils.getAttributeValue(this.entity, (Holder<Attribute>)RuneCraftoryAttributes.MAGIC_DEFENCE.asHolder()), (float)(this.leftPos + statX), (float)(this.topPos + statY + 39), 0, false);
        GuiGraphicsExtension.drawRightAlignedString(graphics, this.font, "" + ((IBaseMob)this.entity).friendPoints((Player)this.minecraft.player), (float)(this.leftPos + statX), (float)(this.topPos + statY + 52), 0, false);
        RenderUtils.renderScaledEntityGui((GuiGraphics)graphics, (float)(this.leftPos + 13), (float)(this.topPos + 18), (float)52.0f, (float)72.0f, (float)27.0f, (float)0.1875f, (float)mouseX, (float)mouseY, this.entity);
    }

    protected abstract void buttons();

    protected ResourceLocation texture() {
        return TEXTURE_PATH;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        float f = this.leftPos;
        Objects.requireNonNull(this);
        GuiGraphicsExtension.drawCenteredString(graphics, this.font, this.title, f + 190.0f * 0.5f, (float)(this.topPos + 7), 0, false);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.minecraft.options.keyInventory.matches(keyCode, scanCode)) {
            this.onClose();
            return true;
        }
        return true;
    }
}

