/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.registry.NPCProfession;
import io.github.flemmli97.runecraftory.client.gui.widgets.SpriteResources;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.entities.npc.profession.ShopState;
import io.github.flemmli97.runecraftory.common.network.C2SNPCInteraction;
import io.github.flemmli97.runecraftory.common.network.C2SProcreationRequest;
import io.github.flemmli97.runecraftory.common.world.data.family.SyncedFamilyData;
import io.github.flemmli97.runecraftory.mixinhelper.GuiGraphicsExtension;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class NPCGui<T extends NPCEntity>
extends Screen {
    private static final ResourceLocation TEXTURE = RuneCraftory.modRes("hud/generic_view");
    private final int offSetX = 140;
    private final int offSetY = 50;
    protected int leftPos;
    protected int topPos;
    private int lines;
    protected final T entity;
    private final ShopState isShopOpen;
    private final boolean canFollow;
    private List<FormattedCharSequence> components;
    private final Map<String, List<Component>> actions;
    private final ResourceLocation quest;
    private final SyncedFamilyData family;
    private final List<ToolTipRenderer> tooltipComponents = new ArrayList<ToolTipRenderer>();

    public NPCGui(T entity, ShopState isShopOpen, boolean canFollow, SyncedFamilyData family, Map<String, List<Component>> actions, ResourceLocation quest) {
        super(entity.getDisplayName());
        this.entity = entity;
        this.isShopOpen = isShopOpen;
        this.canFollow = canFollow;
        this.actions = actions;
        this.quest = quest;
        this.family = family;
    }

    protected void init() {
        super.init();
        this.leftPos = this.width - this.offSetX;
        this.topPos = this.offSetY;
        this.buttons();
    }

    protected void renderBlurredBackground(float partialTick) {
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(graphics, mouseX, mouseY, partialTick);
        int posX = 25;
        int posY = 25;
        int texY = this.lines * 13 + 10;
        boolean renderParents = this.family.father().isPresent() || this.family.mother().isPresent();
        graphics.blitSprite(TEXTURE, posX, posY, 150, texY);
        int txtOffX = posX + 5;
        int txtOffY = posY + 5;
        GuiGraphicsExtension.drawCenteredString(graphics, this.font, this.entity.getName(), (float)(posX + 75), (float)txtOffY, 0, false);
        int y = 1;
        graphics.blitSprite(SpriteResources.HEART_ICON, posX + 65, txtOffY + 13 * y, 8, 8);
        graphics.drawString(this.font, "" + this.entity.friendPoints((Player)this.minecraft.player), posX + 65 + 10, txtOffY + 13 * y, 0, false);
        ++y;
        if (renderParents) {
            if (this.family.father().isEmpty()) {
                graphics.drawString(this.font, (Component)Component.translatable((String)"runecraftory.gui.npc.parent"), txtOffX, txtOffY + 13 * y, 0, false);
                ++y;
                for (FormattedCharSequence ch : this.font.split((FormattedText)this.family.mother().get(), 140)) {
                    graphics.drawString(this.font, ch, txtOffX, txtOffY + 13 * y, 0, false);
                    ++y;
                }
            } else if (this.family.mother().isEmpty()) {
                graphics.drawString(this.font, (Component)Component.translatable((String)"runecraftory.gui.npc.parent"), txtOffX, txtOffY + 13 * y, 0);
                ++y;
                for (FormattedCharSequence ch : this.font.split((FormattedText)this.family.father().get(), 140)) {
                    graphics.drawString(this.font, ch, txtOffX, txtOffY + 13 * y, 0, false);
                    ++y;
                }
            } else {
                graphics.drawString(this.font, (Component)Component.translatable((String)"runecraftory.gui.npc.parents"), txtOffX, txtOffY + 13 * y, 0);
                ++y;
                for (FormattedCharSequence ch : this.font.split((FormattedText)this.family.father().get(), 140)) {
                    graphics.drawString(this.font, ch, txtOffX, txtOffY + 13 * y, 0, false);
                    ++y;
                }
                for (FormattedCharSequence ch : this.font.split((FormattedText)this.family.mother().get(), 140)) {
                    graphics.drawString(this.font, ch, txtOffX, txtOffY + 13 * y, 0, false);
                    ++y;
                }
            }
        }
        if (!this.entity.isBaby()) {
            switch (this.family.relationship()) {
                case NONE: {
                    break;
                }
                case DATING: {
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
                    graphics.blitSprite(SpriteResources.HEARTH_LETTER_ICON, txtOffX, txtOffY + 13 * y, 10, 8);
                    graphics.drawString(this.font, this.family.partner().get(), txtOffX + 12, txtOffY + 13 * y, 0, false);
                    ++y;
                    break;
                }
                case MARRIED: {
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
                    graphics.blitSprite(SpriteResources.ENGAGEMENT_RING_ICON, txtOffX, txtOffY + 13 * y, 10, 8);
                    graphics.drawString(this.font, this.family.partner().get(), txtOffX + 12, txtOffY + 13 * y, 0, false);
                    ++y;
                }
            }
            ++y;
        }
        int shopY = txtOffY + 13 * y;
        int shopSizeY = -5;
        if (!this.entity.isBaby()) {
            MutableComponent shopComp = null;
            if (((NPCEntity)this.entity).getProfession().hasWorkSchedule) {
                shopComp = Component.translatable((String)((NPCEntity)this.entity).getProfession().getOwnerTranslationKey());
            }
            if (shopComp != null) {
                if (this.isShopOpen == ShopState.NOBED || this.isShopOpen == ShopState.NOWORKPLACE) {
                    shopComp.withStyle(ChatFormatting.DARK_RED);
                }
                for (Component comp : this.font.split((FormattedText)shopComp, 140)) {
                    float xCenter = (float)(posX + 75) - (float)this.minecraft.font.width((FormattedCharSequence)comp) * 0.5f;
                    graphics.drawString(this.font, (FormattedCharSequence)comp, (int)xCenter, txtOffY + 13 * y, 0, false);
                    ++y;
                    shopSizeY += 13;
                }
            }
            if (((NPCEntity)this.entity).getProfession().hasWorkSchedule) {
                for (Component comp : ((NPCEntity)this.entity).getNPCSchedule().viewSchedule()) {
                    for (FormattedCharSequence formatted : this.font.split((FormattedText)comp, 140)) {
                        graphics.drawString(this.font, formatted, txtOffX, txtOffY + 13 * y, 0, false);
                        ++y;
                    }
                }
            }
        }
        if (this.components != null && this.isHovering(txtOffX, shopY, 145, shopSizeY, mouseX, mouseY)) {
            graphics.renderTooltip(this.font, this.components, mouseX, mouseY);
        }
        this.tooltipComponents.forEach(r -> r.render(graphics, mouseX, mouseY));
        this.lines = y;
    }

    protected void buttons() {
        int x = -52;
        int xSize = 150;
        int y = 0;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)C2SNPCInteraction.Action.TALK.translation), b -> {
            LoaderNetwork.INSTANCE.sendToServer((CustomPacketPayload)new C2SNPCInteraction(this.entity.getId(), C2SNPCInteraction.Action.TALK));
            this.minecraft.setScreen(null);
        }).bounds(this.leftPos + x, this.topPos + y, xSize, 20).build());
        if (this.canFollow) {
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)C2SNPCInteraction.Action.FOLLOW.translation), b -> {
                LoaderNetwork.INSTANCE.sendToServer((CustomPacketPayload)new C2SNPCInteraction(this.entity.getId(), C2SNPCInteraction.Action.FOLLOW));
                this.minecraft.setScreen(null);
            }).bounds(this.leftPos + x, this.topPos + (y += 30), xSize, 20).build());
        }
        if (!this.entity.isBaby() && this.isShopOpen == ShopState.OPEN) {
            if (((NPCEntity)this.entity).getProfession().hasShop) {
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)C2SNPCInteraction.Action.SHOP.translation), b -> {
                    LoaderNetwork.INSTANCE.sendToServer((CustomPacketPayload)new C2SNPCInteraction(this.entity.getId(), C2SNPCInteraction.Action.SHOP));
                    this.minecraft.setScreen(null);
                }).bounds(this.leftPos + x, this.topPos + (y += 30), xSize, 20).build());
            }
            for (Map.Entry<String, List<Component>> action : this.actions.entrySet()) {
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)action.getKey()), b -> {
                    LoaderNetwork.INSTANCE.sendToServer((CustomPacketPayload)new C2SNPCInteraction(this.entity.getId(), (String)action.getKey()));
                    this.minecraft.setScreen(null);
                }).bounds(this.leftPos + x, this.topPos + (y += 30), xSize, 20).build());
                int tooltipX = this.leftPos + x;
                int tooltipY = this.topPos + y;
                this.tooltipComponents.add((graphics, mouseX, mouseY) -> {
                    if (this.isHovering(tooltipX, tooltipY, xSize, 20, mouseX, mouseY)) {
                        graphics.renderTooltip(this.font, (List)action.getValue(), Optional.empty(), mouseX, mouseY);
                    }
                });
            }
        }
        if (this.quest != null) {
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)C2SNPCInteraction.Action.QUEST.translation), b -> {
                LoaderNetwork.INSTANCE.sendToServer((CustomPacketPayload)new C2SNPCInteraction(this.entity.getId(), C2SNPCInteraction.Action.QUEST, this.quest.toString()));
                this.minecraft.setScreen(null);
            }).bounds(this.leftPos + x, this.topPos + (y += 30), xSize, 20).build());
        }
        if (!this.entity.isBaby() && this.family.canProcreate()) {
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"runecraftory.gui.npc.procreate"), b -> {
                LoaderNetwork.INSTANCE.sendToServer((CustomPacketPayload)new C2SProcreationRequest(this.entity.getId()));
                this.minecraft.setScreen(null);
            }).bounds(this.leftPos + x, this.topPos + (y += 30), xSize, 20).build());
        }
        if (this.isShopOpen == ShopState.NOBED) {
            this.components = new ArrayList<FormattedCharSequence>();
            this.components.addAll(this.font.split((FormattedText)Component.translatable((String)"runecraftory.gui.npc.bed.no"), 150));
        }
        if (!this.entity.isBaby() && this.isShopOpen == ShopState.NOWORKPLACE && ((NPCEntity)this.entity).getProfession().hasPoi()) {
            this.components = new ArrayList<FormattedCharSequence>();
            this.components.addAll(this.font.split((FormattedText)Component.translatable((String)"runecraftory.gui.npc.workplace.no", (Object[])new Object[]{this.formatShopPoi(((NPCEntity)this.entity).getProfession())}), 150));
        }
    }

    private Component formatShopPoi(NPCProfession profession) {
        Set<BlockState> set = profession.matchingStates((HolderLookup.Provider)this.minecraft.level.registryAccess());
        MutableComponent comp = Component.literal((String)"");
        set.stream().map(BlockBehaviour.BlockStateBase::getBlock).distinct().map(Block::getName).forEach(c -> {
            if (comp.getSiblings().isEmpty()) {
                comp.append((Component)c);
            } else {
                comp.append((Component)Component.literal((String)", ").append((Component)c));
            }
        });
        return comp.withStyle(ChatFormatting.AQUA);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.minecraft.options.keyInventory.matches(keyCode, scanCode)) {
            this.onClose();
            return true;
        }
        return true;
    }

    protected boolean isHovering(int x, int y, int width, int height, double mouseX, double mouseY) {
        return mouseX >= (double)(x - 1) && mouseX < (double)(x + width + 1) && mouseY >= (double)(y - 1) && mouseY < (double)(y + height + 1);
    }

    public void removed() {
        super.removed();
        LoaderNetwork.INSTANCE.sendToServer((CustomPacketPayload)new C2SNPCInteraction(this.entity.getId(), C2SNPCInteraction.Action.CLOSE));
    }

    static interface ToolTipRenderer {
        public void render(GuiGraphics var1, int var2, int var3);
    }
}

