/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.gui.widgets;

import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.tenshilib.client.gui.widget.TexturedButton;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class DialogueOptionButton
extends TexturedButton {
    private static final WidgetSprites SPRITE = new WidgetSprites(RuneCraftory.modRes("hud/npc_dialogue"), RuneCraftory.modRes("hud/npc_dialogue_highlighted"));
    public static final int MAX_WIDTH = 100;
    private final List<FormattedCharSequence> text;
    private final int txtX;

    public DialogueOptionButton(int xCenter, int yBottom, Font font, Component text, Button.OnPress press) {
        super(xCenter, yBottom, 0, 0, (Component)Component.empty(), press);
        this.withSprite(SPRITE);
        this.text = font.split((FormattedText)text, 100);
        int txtWidth = this.text.size() == 1 ? font.width((FormattedText)text) : 100;
        this.width = txtWidth + 14;
        int n = this.text.size();
        Objects.requireNonNull(font);
        this.height = n * 9 + 14;
        this.setX(this.getX() - this.width / 2);
        this.setY(this.getY() - this.height);
        this.txtX = this.getX() + this.width / 2;
    }

    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderWidget(graphics, mouseX, mouseY, partialTick);
        int y = 0;
        Font font = Minecraft.getInstance().font;
        int j = this.active ? 0xFFFFFF : 0xA0A0A0;
        for (FormattedCharSequence comp : this.text) {
            graphics.drawString(font, comp, this.txtX - font.width(comp) / 2, this.getY() + 7 + y, j | Mth.ceil((float)(this.alpha * 255.0f)) << 24, false);
            Objects.requireNonNull(font);
            y += 9;
        }
    }
}

