/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.model.armor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class SimpleItemArmorModel
extends EntityModel<Entity> {
    public static final TriConsumer<LivingEntity, PoseStack, ModelPart> TRANSLATE_TO_HEAD = (entity, poseStack, part) -> {
        boolean villager = entity instanceof Villager;
        if (entity.isBaby() && !villager) {
            poseStack.translate(0.0, 0.03125, 0.0);
            poseStack.scale(0.7f, 0.7f, 0.7f);
            poseStack.translate(0.0, 1.0, 0.0);
        }
        part.translateAndRotate(poseStack);
        CustomHeadLayer.translateToHead((PoseStack)poseStack, (boolean)villager);
    };
    private LivingEntity entity;
    private ItemStack stack;
    @Nullable
    private ModelPart part;
    private TriConsumer<LivingEntity, PoseStack, ModelPart> translate;

    public void setProperties(LivingEntity entity, ItemStack stack, ModelPart part, TriConsumer<LivingEntity, PoseStack, ModelPart> translate) {
        this.entity = entity;
        this.stack = stack;
        this.part = part;
        this.translate = translate;
    }

    public void setupAnim(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        if (this.stack == null || this.stack.isEmpty() || this.entity == null) {
            return;
        }
        poseStack.pushPose();
        if (this.translate != null) {
            this.translate.accept(this.entity, poseStack, this.part);
        }
        Minecraft.getInstance().getItemRenderer().renderStatic(this.entity, this.stack, ItemDisplayContext.HEAD, false, poseStack, (MultiBufferSource)Minecraft.getInstance().renderBuffers().bufferSource(), this.entity.level(), packedLight, packedOverlay, 0);
        poseStack.popPose();
    }

    public static interface TriConsumer<A, B, C> {
        public void accept(A var1, B var2, C var3);
    }
}

