/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.tenshilib.client.render.RenderUtils;
import io.github.flemmli97.tenshilib.client.render.layer.RiderEntityLayer;
import java.util.Random;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class RenderMonster<T extends BaseMonster, M extends EntityModel<T>>
extends MobRenderer<T, M> {
    private final ResourceLocation tex;
    private final Random random = new Random();
    private final RenderUtils.BeamBuilder builder = RenderMonster.create();

    public RenderMonster(EntityRendererProvider.Context ctx, M model, ResourceLocation texture, float shadow) {
        this(ctx, model, texture, shadow, true);
    }

    public RenderMonster(EntityRendererProvider.Context ctx, M model, ResourceLocation texture, float shadow, boolean withDefaultRiderLayer) {
        super(ctx, model, shadow);
        this.tex = texture;
        if (withDefaultRiderLayer) {
            this.layers.add(new RiderEntityLayer((LivingEntityRenderer)this));
        }
    }

    private static RenderUtils.BeamBuilder create() {
        RenderUtils.BeamBuilder beam = new RenderUtils.BeamBuilder();
        beam.setEndColor(5293552);
        return beam;
    }

    public void render(T entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        super.render(entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        if (((BaseMonster)entity).deathRays() > 0) {
            poseStack.pushPose();
            poseStack.translate(0.0, ((BaseMonster)entity).deathRayOffset(), 0.0);
            this.random.setSeed(entity.getUUID().getLeastSignificantBits());
            for (int i = 0; i < ((BaseMonster)entity).deathRays(); ++i) {
                poseStack.mulPose(Axis.XP.rotationDegrees(this.random.nextFloat() * 360.0f));
                poseStack.mulPose(Axis.YP.rotationDegrees(this.random.nextFloat() * 360.0f));
                poseStack.mulPose(Axis.ZP.rotationDegrees(this.random.nextFloat() * 360.0f));
                RenderUtils.renderGradientBeam3d((PoseStack)poseStack, (MultiBufferSource)buffer, (float)(entity.getBbWidth() + 3.0f), (float)1.0f, (RenderUtils.BeamBuilder)this.builder);
            }
            poseStack.popPose();
        }
    }

    protected void setupRotations(T entity, PoseStack stack, float ageInTicks, float rotationYaw, float partialTicks, float scale) {
        super.setupRotations(entity, stack, ageInTicks, rotationYaw, partialTicks, scale);
        if (((BaseMonster)entity).getPlayDeathTick() > 0 && ((BaseMonster)entity).getDeathAnimation() == null) {
            float f;
            float f2 = ((float)((BaseMonster)entity).getPlayDeathTick() + (((BaseMonster)entity).playDeath() ? partialTicks : -partialTicks)) / 20.0f * 1.6f;
            f2 = Mth.sqrt((float)f2);
            if (f > 1.0f) {
                f2 = 1.0f;
            }
            stack.translate(0.0, (double)f2 * 0.1, (double)(-f2 * entity.getBbHeight()) * 0.5);
            stack.mulPose(Axis.XP.rotationDegrees(f2 * this.getFlipDegrees(entity)));
        }
    }

    protected float getFlipDegrees(T entity) {
        return ((BaseMonster)entity).getDeathAnimation() != null ? 0.0f : super.getFlipDegrees(entity);
    }

    public boolean shouldRender(T entity, Frustum camera, double camX, double camY, double camZ) {
        if (((BaseMonster)entity).getPlayDeathTick() > 0 && !((BaseMonster)entity).playDeath()) {
            if (((BaseMonster)entity).getPlayDeathTick() > 8 && ((BaseMonster)entity).getPlayDeathTick() % 2 == 0) {
                return false;
            }
            if (((BaseMonster)entity).getPlayDeathTick() % 3 == 0) {
                return false;
            }
        }
        return super.shouldRender(entity, camera, camX, camY, camZ);
    }

    public ResourceLocation getTextureLocation(T entity) {
        return this.tex;
    }
}

