/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.render.npc;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.datapack.npc.NPCLook;
import io.github.flemmli97.runecraftory.api.registry.NPCFeature;
import io.github.flemmli97.runecraftory.api.registry.NPCFeatureType;
import io.github.flemmli97.runecraftory.client.render.npc.NPCArmorLayer;
import io.github.flemmli97.runecraftory.client.render.npc.NPCFaceLayer;
import io.github.flemmli97.runecraftory.client.render.npc.NPCFeatureRenderLayer;
import io.github.flemmli97.runecraftory.client.render.npc.NPCFeatureRenderers;
import io.github.flemmli97.runecraftory.client.render.npc.NPCTextureLayer;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.entities.npc.features.BlushFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.FaceFeaturesType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.HairFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.IndexedColorSettingType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.NPCFeatureContainer;
import io.github.flemmli97.runecraftory.common.entities.npc.features.OutfitFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.SimpleHatFeatureType;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryNPCLooks;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import org.jetbrains.annotations.Nullable;

public class NPCRender<T extends NPCEntity>
extends MobRenderer<T, PlayerModel<T>> {
    private static final Map<String, PlayerSkinData> PLAYER_SKIN_TEXTURE_LOCATIONS = new HashMap<String, PlayerSkinData>();
    private static final Map<String, ResourceLocation> TEXTURE_LAYERS_LOCATIONS = new HashMap<String, ResourceLocation>();
    public static final ResourceLocation EMPTY = RuneCraftory.modRes("textures/entity/npc/empty.png");
    public final NPCArmorLayer<T, PlayerModel<T>, HumanoidModel<T>> armorLayer;
    public final NPCArmorLayer<T, PlayerModel<T>, HumanoidModel<T>> armorLayerSlim;
    public final List<NPCTextureLayer<T, PlayerModel<T>, PlayerModel<T>>> textureLayers = new ArrayList<NPCTextureLayer<T, PlayerModel<T>, PlayerModel<T>>>();

    public NPCRender(EntityRendererProvider.Context ctx) {
        super(ctx, (EntityModel)new PlayerModel(ctx.bakeLayer(ModelLayers.PLAYER), false), 0.5f);
        this.armorLayer = new NPCArmorLayer(this, new HumanoidModel(ctx.bakeLayer(ModelLayers.PLAYER_INNER_ARMOR)), new HumanoidModel(ctx.bakeLayer(ModelLayers.PLAYER_OUTER_ARMOR)), ctx.getModelManager());
        this.addLayer((RenderLayer)this.armorLayer);
        this.armorLayerSlim = new NPCArmorLayer(this, new HumanoidModel(ctx.bakeLayer(ModelLayers.PLAYER_SLIM_INNER_ARMOR)), new HumanoidModel(ctx.bakeLayer(ModelLayers.PLAYER_SLIM_OUTER_ARMOR)), ctx.getModelManager());
        this.addLayer((RenderLayer)this.armorLayerSlim);
        this.addLayer((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, ctx.getItemInHandRenderer()));
        for (NPCTextureLayer.LayerType layerType : NPCTextureLayer.LayerType.values()) {
            if (layerType.location == null) continue;
            if (layerType == NPCTextureLayer.LayerType.SKIN_LAYER) {
                this.textureLayers.add(new NPCTextureLayer(this, (PlayerModel)this.model, new PlayerModel(ctx.bakeLayer(ModelLayers.PLAYER_SLIM), true), layerType));
                continue;
            }
            if (layerType == NPCTextureLayer.LayerType.IRIS_LAYER) {
                this.textureLayers.add(new NPCFaceLayer(this, new PlayerModel(ctx.bakeLayer(layerType.location), false), new PlayerModel(ctx.bakeLayer(layerType.slimLocation), true)));
                continue;
            }
            this.textureLayers.add(new NPCTextureLayer(this, new PlayerModel(ctx.bakeLayer(layerType.location), false), new PlayerModel(ctx.bakeLayer(layerType.slimLocation), true), layerType));
        }
        this.textureLayers.forEach(x$0 -> this.addLayer((RenderLayer)x$0));
        this.addLayer(new NPCFeatureRenderLayer(this));
    }

    public static boolean isSlim(NPCEntity npc) {
        NPCLook look = npc.getLook().value();
        if (look == NPCLook.DEFAULT.value()) {
            return DefaultPlayerSkin.get((UUID)npc.getUUID()).model() == PlayerSkin.Model.SLIM;
        }
        String skin = look.playerSkin();
        if (skin != null) {
            PlayerSkin.Model skinMeta = PLAYER_SKIN_TEXTURE_LOCATIONS.computeIfAbsent(skin, s -> new PlayerSkinData(skin)).getSkinMeta();
            return skinMeta == PlayerSkin.Model.SLIM;
        }
        return npc.lookFeatures.view.containsKey(RuneCraftoryNPCLooks.SLIM.get());
    }

    public static ResourceLocation getTextureFromLook(NPCEntity npc, NPCTextureLayer.LayerType type, @Nullable String subType) {
        NPCLook look = npc.getLook().value();
        if (type == NPCTextureLayer.LayerType.SKIN_LAYER) {
            if (look == NPCLook.DEFAULT.value()) {
                return DefaultPlayerSkin.get((UUID)npc.getUUID()).texture();
            }
            String skin = look.playerSkin();
            if (skin != null) {
                return PLAYER_SKIN_TEXTURE_LOCATIONS.computeIfAbsent(skin, s -> new PlayerSkinData(skin)).getLocation();
            }
        } else if (look.playerSkin() != null || look == NPCLook.DEFAULT.value()) {
            return EMPTY;
        }
        boolean slim = NPCRender.isSlim(npc);
        if (type == NPCTextureLayer.LayerType.HAT_LAYER && npc.hasItemInSlot(EquipmentSlot.HEAD)) {
            return EMPTY;
        }
        return NPCRender.getTextureFromLook(npc.lookFeatures, slim, type, subType);
    }

    public static ResourceLocation getTextureFromLook(NPCFeatureContainer features, boolean slim, NPCTextureLayer.LayerType type, @Nullable String subType) {
        ResourceLocation texture = switch (type) {
            default -> throw new MatchException(null, null);
            case NPCTextureLayer.LayerType.SKIN_LAYER -> {
                Record feat = (IndexedColorSettingType.IndexedColorFeature)features.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.SKIN.get());
                int num = 0;
                if (feat != null) {
                    num = ((IndexedColorSettingType.IndexedColorFeature)feat).index();
                }
                String location = String.format("textures/entity/npc/skin/%s%s.png", slim ? "slim_" : "", num);
                yield TEXTURE_LAYERS_LOCATIONS.computeIfAbsent(location, NPCRender::modLoc);
            }
            case NPCTextureLayer.LayerType.IRIS_LAYER -> {
                Record feat = (FaceFeaturesType.FaceFeatures)features.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.FACE.get());
                int num = 0;
                if (feat != null) {
                    num = ((FaceFeaturesType.FaceFeatures)feat).iris().index();
                    if (subType != null) {
                        subType = ((FaceFeaturesType.FaceFeatures)feat).expressionTexture(features, subType, FaceFeaturesType.ExpressionType.IRIS);
                    }
                }
                String location = String.format("textures/entity/npc/eye/iris_%s%s.png", num, subType != null ? "_" + subType : "");
                yield TEXTURE_LAYERS_LOCATIONS.computeIfAbsent(location, NPCRender::modLoc);
            }
            case NPCTextureLayer.LayerType.SCLERA_LAYER -> {
                Record feat = (FaceFeaturesType.FaceFeatures)features.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.FACE.get());
                int num = 0;
                if (feat != null) {
                    num = ((FaceFeaturesType.FaceFeatures)feat).sclera().index();
                    if (subType != null) {
                        subType = ((FaceFeaturesType.FaceFeatures)feat).expressionTexture(features, subType, FaceFeaturesType.ExpressionType.SCLERA);
                    }
                }
                String location = String.format("textures/entity/npc/eye/sclera_%s%s.png", num, subType != null ? "_" + subType : "");
                yield TEXTURE_LAYERS_LOCATIONS.computeIfAbsent(location, NPCRender::modLoc);
            }
            case NPCTextureLayer.LayerType.EYEBROWS_LAYER -> {
                Record feat = (FaceFeaturesType.FaceFeatures)features.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.FACE.get());
                int num = 0;
                if (feat != null) {
                    num = ((FaceFeaturesType.FaceFeatures)feat).eyebrow().index();
                    if (subType != null) {
                        subType = ((FaceFeaturesType.FaceFeatures)feat).expressionTexture(features, subType, FaceFeaturesType.ExpressionType.EYEBROWS);
                    }
                }
                String location = String.format("textures/entity/npc/eye/eyebrows_%s%s.png", num, subType != null ? "_" + subType : "");
                yield TEXTURE_LAYERS_LOCATIONS.computeIfAbsent(location, NPCRender::modLoc);
            }
            case NPCTextureLayer.LayerType.BLUSH_LAYER -> {
                Record feat = (BlushFeatureType.BlushFeature)features.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.BLUSH.get());
                if (feat == null || !((BlushFeatureType.BlushFeature)feat).blush()) {
                    yield null;
                }
                String location = "textures/entity/npc/misc/blush.png";
                yield TEXTURE_LAYERS_LOCATIONS.computeIfAbsent(location, NPCRender::modLoc);
            }
            case NPCTextureLayer.LayerType.OUTFIT_LAYER -> {
                Record feat = (OutfitFeatureType.OutfitFeature)features.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.OUTFIT.get());
                String location = String.format("textures/entity/npc/outfit/generic%s_0.png", slim ? "_slim" : "");
                if (feat != null) {
                    location = String.format("textures/entity/npc/outfit/%s%s_%s.png", ((OutfitFeatureType.OutfitFeature)feat).outfit(), slim ? "_slim" : "", ((OutfitFeatureType.OutfitFeature)feat).index());
                }
                yield TEXTURE_LAYERS_LOCATIONS.computeIfAbsent(location, NPCRender::modLoc);
            }
            case NPCTextureLayer.LayerType.HAIR_LAYER -> {
                Record feat = (HairFeatureType.HairFeature)features.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.HAIR.get());
                if (feat == null) {
                    yield null;
                }
                String location = String.format("textures/entity/npc/hair/%s_%s.png", ((HairFeatureType.HairFeature)feat).hair(), ((HairFeatureType.HairFeature)feat).index());
                yield TEXTURE_LAYERS_LOCATIONS.computeIfAbsent(location, NPCRender::modLoc);
            }
            case NPCTextureLayer.LayerType.HAT_LAYER -> {
                Record feat = (SimpleHatFeatureType.SimpleHatFeature)features.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.HAT.get());
                if (feat == null || ((SimpleHatFeatureType.SimpleHatFeature)feat).hat().isEmpty()) {
                    yield null;
                }
                String location = String.format("textures/entity/npc/misc/%s.png", ((SimpleHatFeatureType.SimpleHatFeature)feat).hat());
                yield TEXTURE_LAYERS_LOCATIONS.computeIfAbsent(location, NPCRender::modLoc);
            }
        };
        return texture == null ? EMPTY : texture;
    }

    private static ResourceLocation modLoc(String s) {
        return RuneCraftory.modRes(s);
    }

    public static boolean renderForTooltip(GuiGraphics graphics, int x, int y, @Nullable String skin, List<Pair<Integer, ResourceLocation>> textures) {
        if (skin == null && textures == null) {
            return false;
        }
        int sizeX = 16;
        int sizeY = 16;
        if (skin != null) {
            ResourceLocation res = PLAYER_SKIN_TEXTURE_LOCATIONS.computeIfAbsent(skin, s -> new PlayerSkinData(skin)).getLocation();
            graphics.blit(res, x, y, sizeX, sizeY, 8.0f, 8.0f, 8, 8, 64, 64);
            RenderSystem.enableBlend();
            graphics.blit(res, x, y, sizeX, sizeY, 40.0f, 8.0f, 8, 8, 64, 64);
            RenderSystem.disableBlend();
        } else {
            for (Pair<Integer, ResourceLocation> layer : textures) {
                int color = (Integer)layer.getFirst();
                float a = (float)(color >> 24 & 0xFF) / 255.0f;
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
                graphics.blit((ResourceLocation)layer.getSecond(), x, y, sizeX, sizeY, 8.0f, 8.0f, 8, 8, 64, 64);
                RenderSystem.enableBlend();
                graphics.blit((ResourceLocation)layer.getSecond(), x, y, sizeX, sizeY, 40.0f, 8.0f, 8, 8, 64, 64);
                RenderSystem.disableBlend();
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        return true;
    }

    protected boolean shouldShowName(T entity) {
        return false;
    }

    public void render(T entity, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        boolean slim = NPCRender.isSlim(entity);
        this.armorLayer.setRender(!slim);
        this.armorLayerSlim.setRender(slim);
        for (NPCFeature feature : ((NPCEntity)entity).lookFeatures.view.values()) {
            NPCFeatureRenderers.get(feature).onSetup(feature, this, entity, stack);
        }
        this.setModelProperties((NPCEntity)entity);
        super.render(entity, entityYaw, partialTicks, stack, buffer, packedLight);
    }

    private void setModelProperties(NPCEntity npc) {
        PlayerModel playerModel = (PlayerModel)this.getModel();
        playerModel.setAllVisible(true);
        playerModel.crouching = npc.isCrouching();
        HumanoidModel.ArmPose main = NPCRender.getArmPose(npc, InteractionHand.MAIN_HAND);
        HumanoidModel.ArmPose off = NPCRender.getArmPose(npc, InteractionHand.OFF_HAND);
        if (npc.getMainArm() == HumanoidArm.RIGHT) {
            playerModel.rightArmPose = main;
            playerModel.leftArmPose = off;
        } else {
            playerModel.rightArmPose = off;
            playerModel.leftArmPose = main;
        }
    }

    private static HumanoidModel.ArmPose getArmPose(NPCEntity npc, InteractionHand hand) {
        ItemStack itemStack = npc.getItemInHand(hand);
        if (itemStack.isEmpty()) {
            return HumanoidModel.ArmPose.EMPTY;
        }
        if (npc.getUsedItemHand() == hand && npc.getUseItemRemainingTicks() > 0) {
            UseAnim useAnim = itemStack.getUseAnimation();
            if (useAnim == UseAnim.BLOCK) {
                return HumanoidModel.ArmPose.BLOCK;
            }
            if (useAnim == UseAnim.BOW) {
                return HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
            if (useAnim == UseAnim.SPEAR) {
                return HumanoidModel.ArmPose.THROW_SPEAR;
            }
            if (useAnim == UseAnim.CROSSBOW && hand == npc.getUsedItemHand()) {
                return HumanoidModel.ArmPose.CROSSBOW_CHARGE;
            }
            if (useAnim == UseAnim.SPYGLASS) {
                return HumanoidModel.ArmPose.SPYGLASS;
            }
        } else if (!npc.swinging && itemStack.is(Items.CROSSBOW) && CrossbowItem.isCharged((ItemStack)itemStack)) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        return HumanoidModel.ArmPose.ITEM;
    }

    public ResourceLocation getTextureLocation(T entity) {
        return NPCRender.getTextureFromLook(entity, NPCTextureLayer.LayerType.SKIN_LAYER, null);
    }

    protected void setupRotations(T entity, PoseStack stack, float bob, float yBodyRot, float partialTick, float scale) {
        super.setupRotations(entity, stack, bob, yBodyRot, partialTick, scale);
        if (((NPCEntity)entity).getPlayDeathTick() > 0) {
            float f;
            float partial = partialTick - 1.0f;
            float f2 = ((float)((NPCEntity)entity).getPlayDeathTick() + (((NPCEntity)entity).playDeath() ? partial : -partial)) / 20.0f * 1.6f;
            f2 = Mth.sqrt((float)f2);
            if (f > 1.0f) {
                f2 = 1.0f;
            }
            stack.translate(0.0, (double)f2 * 0.1, (double)(-f2 * entity.getBbHeight()) * 0.5);
            stack.mulPose(Axis.XP.rotationDegrees(f2 * this.getFlipDegrees((LivingEntity)entity)));
        }
        for (NPCFeature feature : ((NPCEntity)entity).lookFeatures.view.values()) {
            NPCFeatureRenderers.get(feature).transformStack(feature, this, entity, stack, partialTick);
        }
    }

    protected void scale(T livingEntity, PoseStack matrixStack, float partialTickTime) {
        matrixStack.scale(0.9375f, 0.9375f, 0.9375f);
    }

    @Nullable
    protected RenderType getRenderType(T entity, boolean invis, boolean translucent, boolean glowing) {
        return null;
    }

    static class PlayerSkinData {
        private GameProfile gameProfile;
        private ResourceLocation location = DefaultPlayerSkin.getDefaultTexture();
        private PlayerSkin.Model skinMeta = PlayerSkin.Model.SLIM;
        private boolean pendingTextures;

        public PlayerSkinData(String name) {
            SkullBlockEntity.fetchGameProfile((String)name).thenAccept(prof -> prof.ifPresent(p -> {
                this.gameProfile = p;
            }));
        }

        public ResourceLocation getLocation() {
            this.registerTextures();
            return this.location;
        }

        public PlayerSkin.Model getSkinMeta() {
            this.registerTextures();
            return this.skinMeta;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void registerTextures() {
            PlayerSkinData playerSkinData = this;
            synchronized (playerSkinData) {
                if (!this.pendingTextures && this.gameProfile != null) {
                    this.pendingTextures = true;
                    Minecraft.getInstance().getSkinManager().getOrLoad(this.gameProfile).thenAccept(skin -> {
                        this.location = skin.texture();
                        this.skinMeta = skin.model();
                    });
                }
            }
        }
    }
}

