/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.render.npc;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.registry.NPCFeatureType;
import io.github.flemmli97.runecraftory.client.render.npc.NPCRender;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.entities.npc.features.BlushFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.FaceFeaturesType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.HairFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.IndexedColorSettingType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.NPCFeatureContainer;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryNPCLooks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class NPCTextureLayer<T extends NPCEntity, M extends HumanoidModel<T>, A extends PlayerModel<T>>
extends RenderLayer<T, M> {
    private final A model;
    private final A slimModel;
    protected LayerType layer;

    public NPCTextureLayer(RenderLayerParent<T, M> renderer, A model, A slimModel, LayerType layer) {
        super(renderer);
        this.model = model;
        this.slimModel = slimModel;
        this.layer = layer;
    }

    public static int setColor(NPCFeatureContainer features, LayerType layer) {
        int color = switch (layer.ordinal()) {
            case 0 -> {
                Record feat = (IndexedColorSettingType.IndexedColorFeature)features.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.SKIN.get());
                if (feat == null) {
                    yield 14008231;
                }
                yield ((IndexedColorSettingType.IndexedColorFeature)feat).color();
            }
            case 2 -> {
                Record feat = (FaceFeaturesType.FaceFeatures)features.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.FACE.get());
                if (feat == null || ((FaceFeaturesType.FaceFeatures)feat).iris() == null) {
                    yield 0;
                }
                yield ((FaceFeaturesType.FaceFeatures)feat).iris().color();
            }
            case 3 -> {
                Record feat = (FaceFeaturesType.FaceFeatures)features.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.FACE.get());
                if (feat == null || ((FaceFeaturesType.FaceFeatures)feat).sclera() == null) {
                    yield 0;
                }
                yield ((FaceFeaturesType.FaceFeatures)feat).sclera().color();
            }
            case 4 -> {
                Record feat = (FaceFeaturesType.FaceFeatures)features.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.FACE.get());
                if (feat == null || ((FaceFeaturesType.FaceFeatures)feat).eyebrow() == null) {
                    yield 0;
                }
                yield ((FaceFeaturesType.FaceFeatures)feat).eyebrow().color();
            }
            case 5 -> {
                Record feat = (BlushFeatureType.BlushFeature)features.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.BLUSH.get());
                if (feat == null) {
                    yield 0xFFFFFF;
                }
                yield ((BlushFeatureType.BlushFeature)feat).color();
            }
            case 6 -> {
                Record feat = (HairFeatureType.HairFeature)features.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.HAIR.get());
                if (feat == null) {
                    yield 0xFFFFFF;
                }
                yield ((HairFeatureType.HairFeature)feat).color();
            }
            default -> 0xFFFFFF;
        };
        int a = 255;
        if (layer == LayerType.BLUSH_LAYER) {
            a = 88;
        }
        return a << 24 | color;
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, T npc, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        A layerModel = this.getModel(npc);
        this.setup(layerModel);
        this.actualRender(poseStack, buffer, packedLight, npc, layerModel);
    }

    protected A getModel(T npc) {
        return NPCRender.isSlim(npc) ? this.slimModel : this.model;
    }

    protected void setup(A layerModel) {
        ((HumanoidModel)this.getParentModel()).copyPropertiesTo(layerModel);
        ((PlayerModel)layerModel).leftPants.copyFrom(((HumanoidModel)this.getParentModel()).leftLeg);
        ((PlayerModel)layerModel).rightPants.copyFrom(((HumanoidModel)this.getParentModel()).rightLeg);
        ((PlayerModel)layerModel).leftSleeve.copyFrom(((HumanoidModel)this.getParentModel()).leftArm);
        ((PlayerModel)layerModel).rightSleeve.copyFrom(((HumanoidModel)this.getParentModel()).rightArm);
        ((PlayerModel)layerModel).jacket.copyFrom(((HumanoidModel)this.getParentModel()).body);
        this.setPartVisibility(layerModel);
    }

    protected void actualRender(PoseStack poseStack, MultiBufferSource buffer, int packedLight, T npc, A layerModel) {
        boolean bl3;
        boolean bl2;
        Minecraft mc = Minecraft.getInstance();
        boolean bl = !npc.isInvisible();
        RenderType renderType = this.getRenderType(npc, layerModel, bl, bl2 = !bl && !npc.isInvisibleTo((Player)mc.player), bl3 = mc.shouldEntityAppearGlowing(npc));
        if (renderType != null) {
            VertexConsumer vertexConsumer = buffer.getBuffer(renderType);
            int m = LivingEntityRenderer.getOverlayCoords(npc, (float)0.0f);
            int color = this.setColor(npc);
            float a = (float)(color >> 24 & 0xFF) / 255.0f;
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            layerModel.renderToBuffer(poseStack, vertexConsumer, packedLight, m, FastColor.ARGB32.colorFromFloat((float)(a * (bl2 ? 0.15f : 1.0f)), (float)r, (float)g, (float)b));
        }
    }

    @Nullable
    protected RenderType getRenderType(T entity, A model, boolean bodyVisible, boolean translucent, boolean glowing) {
        ResourceLocation resourceLocation;
        if (((NPCEntity)entity).getPlayDeathTick() > 0 && !((NPCEntity)entity).playDeath()) {
            if (((NPCEntity)entity).getPlayDeathTick() > 8 && ((NPCEntity)entity).getPlayDeathTick() % 2 == 0) {
                return null;
            }
            if (((NPCEntity)entity).getPlayDeathTick() % 3 == 0) {
                return null;
            }
        }
        if ((resourceLocation = this.getTexture(entity)).equals((Object)NPCRender.EMPTY)) {
            return null;
        }
        if (translucent) {
            return RenderType.itemEntityTranslucentCull((ResourceLocation)resourceLocation);
        }
        if (bodyVisible) {
            return model.renderType(resourceLocation);
        }
        if (glowing) {
            return RenderType.outline((ResourceLocation)resourceLocation);
        }
        return null;
    }

    protected int setColor(T entity) {
        return NPCTextureLayer.setColor(((NPCEntity)entity).lookFeatures, this.layer);
    }

    protected ResourceLocation getTexture(T entity) {
        return NPCRender.getTextureFromLook(entity, this.layer, null);
    }

    protected void setPartVisibility(A model) {
        model.setAllVisible(false);
        ((PlayerModel)model).head.visible = true;
        ((PlayerModel)model).hat.visible = true;
        switch (this.layer.ordinal()) {
            case 0: 
            case 1: {
                model.setAllVisible(true);
            }
            case 6: {
                ((PlayerModel)model).body.visible = true;
                ((PlayerModel)model).jacket.visible = true;
                ((PlayerModel)model).rightArm.visible = true;
                ((PlayerModel)model).rightSleeve.visible = true;
                ((PlayerModel)model).leftArm.visible = true;
                ((PlayerModel)model).leftSleeve.visible = true;
            }
        }
    }

    public static enum LayerType {
        SKIN_LAYER("skin", 0.0f),
        OUTFIT_LAYER("outft", 0.005f),
        IRIS_LAYER("eyes", 0.006f),
        SCLERA_LAYER(null, 0.007f),
        EYEBROWS_LAYER(null, 0.008f),
        BLUSH_LAYER("blush", 0.009f),
        HAIR_LAYER("hair", 0.5f),
        HAT_LAYER("hats", 0.8f);

        public final ModelLayerLocation location;
        public final ModelLayerLocation slimLocation;
        public final float expand;

        private LayerType(String name, float expand) {
            this.location = name == null ? null : new ModelLayerLocation(RuneCraftory.modRes("npc_" + name), "main");
            this.slimLocation = name == null ? null : new ModelLayerLocation(RuneCraftory.modRes("npc_slim_" + name), "main");
            this.expand = expand;
        }
    }
}

