/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.render.projectiles;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.common.entities.misc.CardsEntity;
import io.github.flemmli97.tenshilib.client.render.TextureRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class CardsRender
extends TextureRenderer<CardsEntity> {
    private static final ResourceLocation TEX_1 = RuneCraftory.modRes("textures/entity/projectile/card_b_1.png");
    private static final ResourceLocation TEX_2 = RuneCraftory.modRes("textures/entity/projectile/card_b_2.png");
    private static final ResourceLocation TEX_3 = RuneCraftory.modRes("textures/entity/projectile/card_b_3.png");
    private static final ResourceLocation TEX_4 = RuneCraftory.modRes("textures/entity/projectile/card_b_4.png");
    private static final ResourceLocation TEX_5 = RuneCraftory.modRes("textures/entity/projectile/card_r_1.png");
    private static final ResourceLocation TEX_6 = RuneCraftory.modRes("textures/entity/projectile/card_r_2.png");
    private static final ResourceLocation TEX_7 = RuneCraftory.modRes("textures/entity/projectile/card_r_3.png");
    private static final ResourceLocation TEX_8 = RuneCraftory.modRes("textures/entity/projectile/card_r_4.png");

    public CardsRender(EntityRendererProvider.Context ctx) {
        super(ctx, 1.0f, 1.0f, 1, 1);
    }

    public ResourceLocation getTextureLocation(CardsEntity entity) {
        return switch (entity.getCardType()) {
            case 1 -> TEX_2;
            case 2 -> TEX_3;
            case 3 -> TEX_4;
            case 4 -> TEX_5;
            case 5 -> TEX_6;
            case 6 -> TEX_7;
            case 7 -> TEX_8;
            default -> TEX_1;
        };
    }

    public void render(CardsEntity entity, float rotation, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        stack.pushPose();
        stack.scale(0.8f, 0.8f, 0.8f);
        stack.translate(0.0, 0.3, 0.0);
        super.render((Entity)entity, rotation, partialTicks, stack, buffer, packedLight);
        stack.popPose();
    }

    public boolean facePlayer() {
        return false;
    }

    public float yawOffset() {
        return 90.0f;
    }

    public float pitchOffset() {
        return -90.0f;
    }
}

