/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.render.projectiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.client.model.misc.EnergyOrbModel;
import io.github.flemmli97.runecraftory.client.render.layer.EnergyOrbSwirlLayer;
import io.github.flemmli97.runecraftory.common.entities.misc.HomingEnergyOrbEntity;
import io.github.flemmli97.tenshilib.client.render.SimpleModelRenderer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class EnergyOrbRender
extends SimpleModelRenderer<HomingEnergyOrbEntity>
implements RenderLayerParent<HomingEnergyOrbEntity, EntityModel<HomingEnergyOrbEntity>> {
    public static final ResourceLocation TEXTURE = RuneCraftory.modRes("textures/entity/projectile/energy_orb.png");
    private static final RenderType BEAM_RENDER_TYPE = RenderType.entityCutoutNoCull((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"textures/entity/guardian_beam.png"));
    private final EnergyOrbSwirlLayer layer;

    public EnergyOrbRender(EntityRendererProvider.Context ctx) {
        super(ctx, new EnergyOrbModel(1.0f));
        this.layer = new EnergyOrbSwirlLayer(this, ctx.getModelSet());
        this.alpha = 0.8f;
    }

    public void render(HomingEnergyOrbEntity entity, float rotation, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        stack.pushPose();
        super.render((Entity)entity, rotation, partialTicks, stack, buffer, packedLight);
        stack.popPose();
        Vec3 start = entity.rootPosition(partialTicks);
        if (start == null) {
            return;
        }
        Vec3 vec32 = this.getPositionLerped((Entity)entity, partialTicks);
        Vec3 dir = start.subtract(vec32);
        float len = (float)(dir.length() + 1.0);
        dir = dir.normalize();
        float beamPitch = (float)Math.acos(dir.y);
        float beamYaw = (float)Math.atan2(dir.z, dir.x);
        stack.pushPose();
        stack.translate(0.0, (double)entity.getBbHeight() * 0.5, 0.0);
        stack.mulPose(Axis.YP.rotationDegrees(90.0f - beamYaw * 57.295776f));
        stack.mulPose(Axis.XP.rotationDegrees(beamPitch * 57.295776f));
        float colorScale = Mth.sin((float)entity.tickCount) * 0.5f + 0.5f;
        int red = 66 + (int)(colorScale * 100.0f);
        int green = 154 + (int)(colorScale * 56.0f);
        int blue = 207 - (int)(colorScale * 30.0f);
        float tick = (float)entity.tickCount + partialTicks;
        float h = tick * 0.5f % 1.0f;
        float n = tick * 0.05f * -1.5f;
        float u = Mth.cos((float)(n + 2.3561945f)) * 0.282f;
        float v = Mth.sin((float)(n + 2.3561945f)) * 0.282f;
        float w = Mth.cos((float)(n + 0.7853982f)) * 0.282f;
        float x = Mth.sin((float)(n + 0.7853982f)) * 0.282f;
        float y = Mth.cos((float)(n + 3.926991f)) * 0.282f;
        float z = Mth.sin((float)(n + 3.926991f)) * 0.282f;
        float aa = Mth.cos((float)(n + 5.4977875f)) * 0.282f;
        float ab = Mth.sin((float)(n + 5.4977875f)) * 0.282f;
        float ac = Mth.cos((float)(n + (float)Math.PI)) * 0.2f;
        float ad = Mth.sin((float)(n + (float)Math.PI)) * 0.2f;
        float ae = Mth.cos((float)(n + 0.0f)) * 0.2f;
        float af = Mth.sin((float)(n + 0.0f)) * 0.2f;
        float ag = Mth.cos((float)(n + 1.5707964f)) * 0.2f;
        float ah = Mth.sin((float)(n + 1.5707964f)) * 0.2f;
        float ai = Mth.cos((float)(n + 4.712389f)) * 0.2f;
        float aj = Mth.sin((float)(n + 4.712389f)) * 0.2f;
        float an = -1.0f + h;
        float ao = len * 2.5f + an;
        VertexConsumer vertexConsumer = buffer.getBuffer(BEAM_RENDER_TYPE);
        PoseStack.Pose pose = stack.last();
        EnergyOrbRender.vertex(vertexConsumer, pose, ac, len, ad, red, green, blue, 0.4999f, ao);
        EnergyOrbRender.vertex(vertexConsumer, pose, ac, 0.0f, ad, red, green, blue, 0.4999f, an);
        EnergyOrbRender.vertex(vertexConsumer, pose, ae, 0.0f, af, red, green, blue, 0.0f, an);
        EnergyOrbRender.vertex(vertexConsumer, pose, ae, len, af, red, green, blue, 0.0f, ao);
        EnergyOrbRender.vertex(vertexConsumer, pose, ag, len, ah, red, green, blue, 0.4999f, ao);
        EnergyOrbRender.vertex(vertexConsumer, pose, ag, 0.0f, ah, red, green, blue, 0.4999f, an);
        EnergyOrbRender.vertex(vertexConsumer, pose, ai, 0.0f, aj, red, green, blue, 0.0f, an);
        EnergyOrbRender.vertex(vertexConsumer, pose, ai, len, aj, red, green, blue, 0.0f, ao);
        float ap = 0.0f;
        if (entity.tickCount % 2 == 0) {
            ap = 0.5f;
        }
        EnergyOrbRender.vertex(vertexConsumer, pose, u, len, v, red, green, blue, 0.5f, ap + 0.5f);
        EnergyOrbRender.vertex(vertexConsumer, pose, w, len, x, red, green, blue, 1.0f, ap + 0.5f);
        EnergyOrbRender.vertex(vertexConsumer, pose, aa, len, ab, red, green, blue, 1.0f, ap);
        EnergyOrbRender.vertex(vertexConsumer, pose, y, len, z, red, green, blue, 0.5f, ap);
        stack.popPose();
    }

    private Vec3 getPositionLerped(Entity livingEntity, float partialTick) {
        double x = Mth.lerp((double)partialTick, (double)livingEntity.xOld, (double)livingEntity.getX());
        double y = Mth.lerp((double)partialTick, (double)livingEntity.yOld, (double)livingEntity.getY()) + (double)livingEntity.getBbHeight() * 0.5;
        double z = Mth.lerp((double)partialTick, (double)livingEntity.zOld, (double)livingEntity.getZ());
        return new Vec3(x, y, z);
    }

    private static void vertex(VertexConsumer vertexConsumer, PoseStack.Pose pose, float x, float y, float z, int r, int g, int b, float u, float v) {
        vertexConsumer.addVertex(pose, x, y, z).setColor(r, g, b, 200).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
    }

    public void translate(HomingEnergyOrbEntity entity, PoseStack stack, float pitch, float yaw, float partialTicks) {
        super.translate((Entity)entity, stack, 0.0f, 0.0f, partialTicks);
        stack.translate(0.0, 0.0625, 0.0);
    }

    public void afterModelRender(HomingEnergyOrbEntity entity, float rotation, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        float yaw = Mth.lerp((float)partialTicks, (float)entity.yRotO, (float)entity.getYRot()) + this.yawOffset();
        float pitch = Mth.lerp((float)partialTicks, (float)entity.xRotO, (float)entity.getXRot()) + this.pitchOffset();
        this.layer.render(stack, buffer, packedLight, (Entity)entity, 0.0f, 0.0f, partialTicks, entity.tickCount, yaw, pitch);
    }

    public EntityModel<HomingEnergyOrbEntity> getModel() {
        return this.model;
    }

    public ResourceLocation getTextureLocation(HomingEnergyOrbEntity entity) {
        return TEXTURE;
    }
}

