/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.render.projectiles;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.client.model.SimpleGeoModel;
import io.github.flemmli97.runecraftory.common.entities.misc.SpikeEntity;
import io.github.flemmli97.tenshilib.client.render.SimpleModelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;

public class SpikesRender<T extends SpikeEntity>
extends SimpleModelRenderer<T> {
    private static final ResourceLocation EARTH_SPIKE = RuneCraftory.modRes("textures/entity/projectile/spikes_dirt_tiled.png");
    private static final ResourceLocation BRANCHES = RuneCraftory.modRes("textures/entity/projectile/spikes_wood_tiled.png");
    private static final ResourceLocation MODEL_LOCATION = RuneCraftory.modRes("entity/spikes");

    public SpikesRender(EntityRendererProvider.Context ctx) {
        super(ctx, new SimpleGeoModel(MODEL_LOCATION));
    }

    public void render(T entity, float rotation, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        if (((SpikeEntity)((Object)entity)).getAnimationProgress(partialTicks) > 0.0f) {
            super.render(entity, rotation, partialTicks, stack, buffer, packedLight);
        }
    }

    public void translate(T entity, PoseStack stack, float pitch, float yaw, float partialTicks) {
        float scale = ((SpikeEntity)((Object)entity)).getAnimationProgress(partialTicks);
        stack.scale(1.0f, scale, 1.0f);
        super.translate(entity, stack, 0.0f, 0.0f, partialTicks);
    }

    public ResourceLocation getTextureLocation(T entity) {
        return ((SpikeEntity)((Object)entity)).spikeType() == 1 ? BRANCHES : EARTH_SPIKE;
    }
}

