/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryCriteria;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;

public class CropHarvestTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, BlockState state) {
        this.trigger(player, inst -> inst.matches(state));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, HolderSet<Block> block, Optional<StatePropertiesPredicate> predicate) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BLOCK, (Codec)Block.CODEC.codec()).fieldOf("block").forGetter(d -> d.block), (App)StatePropertiesPredicate.CODEC.optionalFieldOf("predicate").forGetter(d -> d.predicate)).apply((Applicative)inst, TriggerInstance::new));

        public static Criterion<TriggerInstance> harvest(TagKey<Block> tag) {
            return ((CropHarvestTrigger)((Object)RuneCraftoryCriteria.HARVEST_CROP.get())).createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), (HolderSet<Block>)BuiltInRegistries.BLOCK.getOrCreateTag(tag), Optional.empty()));
        }

        public boolean matches(BlockState state) {
            CropBlock crop;
            Block block = state.getBlock();
            if (!(block instanceof CropBlock) || !(crop = (CropBlock)block).isMaxAge(state)) {
                return false;
            }
            if (!state.is(this.block)) {
                return false;
            }
            return this.predicate.map(p -> p.matches(state)).orElse(true);
        }
    }
}

