/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryCriteria;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;

public class ShippingTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, PlayerData data, ItemStack stack) {
        this.trigger(player, inst -> inst.matches(data, stack));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<ItemPredicate> predicate, int amount) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)ItemPredicate.CODEC.optionalFieldOf("predicate").forGetter(TriggerInstance::predicate), (App)ExtraCodecs.POSITIVE_INT.fieldOf("amount").forGetter(TriggerInstance::amount)).apply((Applicative)inst, TriggerInstance::new));

        public static Criterion<TriggerInstance> shipAny(int amount) {
            return ((ShippingTrigger)((Object)RuneCraftoryCriteria.SHIPPING_TRIGGER.get())).createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), Optional.empty(), amount));
        }

        public static Criterion<TriggerInstance> shipSpecific(ItemPredicate.Builder item, int amount) {
            return ((ShippingTrigger)((Object)RuneCraftoryCriteria.SHIPPING_TRIGGER.get())).createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), Optional.of(item.build()), amount));
        }

        public boolean matches(PlayerData data, ItemStack stack) {
            if (this.predicate.isPresent()) {
                if (!this.predicate.get().test(stack)) {
                    return false;
                }
                PlayerData.ShippedItemData shipped = data.shippedItemData(stack);
                return shipped != null && shipped.amount() >= this.amount;
            }
            return data.getShippedTypesAmount() >= this.amount;
        }
    }
}

