/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryCriteria;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;

public class ShopTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, NPCEntity npc, ItemStack stack) {
        LootContext lootContext = EntityPredicate.createContext((ServerPlayer)player, (Entity)npc);
        this.trigger(player, inst -> inst.matches(lootContext, stack));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<ContextAwarePredicate> target, Optional<ItemPredicate> item) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("target").forGetter(TriggerInstance::target), (App)ItemPredicate.CODEC.optionalFieldOf("item").forGetter(TriggerInstance::item)).apply((Applicative)inst, TriggerInstance::new));

        public static Criterion<TriggerInstance> buyAny() {
            return ((ShopTrigger)((Object)RuneCraftoryCriteria.SHOP_TRIGGER.get())).createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), Optional.empty(), Optional.empty()));
        }

        public static Criterion<TriggerInstance> buyFromItem(EntityPredicate.Builder npc, ItemPredicate.Builder item) {
            return ((ShopTrigger)((Object)RuneCraftoryCriteria.SHOP_TRIGGER.get())).createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), Optional.of(EntityPredicate.wrap((EntityPredicate.Builder)npc)), Optional.of(item.build())));
        }

        public boolean matches(LootContext context, ItemStack stack) {
            if (!this.target.map(p -> p.matches(context)).orElse(true).booleanValue()) {
                return false;
            }
            return this.item.map(p -> p.test(stack)).orElse(true);
        }
    }
}

