/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attachment.player;

import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.player.Player;

public class WalkingTracker {
    private static final Map<ResourceLocation, Float> RELEVANT_STATS = WalkingTracker.relevantStatMap();
    private final Map<ResourceLocation, Integer> lastCheck = new HashMap<ResourceLocation, Integer>();

    private static Map<ResourceLocation, Float> relevantStatMap() {
        HashMap<ResourceLocation, Float> map = new HashMap<ResourceLocation, Float>();
        map.put(Stats.WALK_ONE_CM, Float.valueOf(0.8f));
        map.put(Stats.CROUCH_ONE_CM, Float.valueOf(1.25f));
        map.put(Stats.SPRINT_ONE_CM, Float.valueOf(0.3f));
        map.put(Stats.WALK_ON_WATER_ONE_CM, Float.valueOf(0.9f));
        map.put(Stats.WALK_UNDER_WATER_ONE_CM, Float.valueOf(1.0f));
        map.put(Stats.SWIM_ONE_CM, Float.valueOf(0.65f));
        map.put(Stats.FLY_ONE_CM, Float.valueOf(0.15f));
        map.put(Stats.AVIATE_ONE_CM, Float.valueOf(0.07f));
        return map;
    }

    public boolean tickWalkingTracker(ServerPlayer player) {
        ServerStatsCounter counter = player.getStats();
        float mult = 0.0f;
        for (Map.Entry<ResourceLocation, Float> e : RELEVANT_STATS.entrySet()) {
            mult += this.calcMultiplier(e.getKey(), counter, e.getValue().floatValue());
        }
        if (mult != 0.0f) {
            float finalMult = mult * 0.3f;
            LevelCalc.levelSkill(Platform.INSTANCE.getPlayerData((Player)player), Skills.WALKING, finalMult);
        }
        return mult != 0.0f;
    }

    private float calcMultiplier(ResourceLocation res, ServerStatsCounter counter, float weight) {
        int last = this.lastCheck.getOrDefault(res, 0);
        int current = counter.getValue(Stats.CUSTOM.get((Object)res));
        if (Math.abs(current - last) > 0) {
            float m = (float)Math.min(current - last, 1000) * weight * 0.005f;
            this.lastCheck.put(res, current);
            return m;
        }
        return 0.0f;
    }

    public CompoundTag save() {
        CompoundTag compound = new CompoundTag();
        this.lastCheck.forEach((res, v) -> compound.putInt(res.toString(), v.intValue()));
        return compound;
    }

    public void read(CompoundTag compound) {
        compound.getAllKeys().forEach(key -> this.lastCheck.put(ResourceLocation.parse((String)key), compound.getInt(key)));
    }
}

