/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attackactions;

import io.github.flemmli97.runecraftory.api.registry.action.AttackAction;
import io.github.flemmli97.runecraftory.api.registry.action.DataKey;
import io.github.flemmli97.runecraftory.api.registry.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.common.attachment.AttackActionHandler;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class AxelDisasterAttack
extends AttackAction {
    @Override
    public AnimationState getAnimation(LivingEntity entity, int comboIdx) {
        double speed = EntityUtils.attackSpeedModifier(entity);
        return AttackAction.create(PlayerModelAnimations.AXEL_DISASTER, speed);
    }

    @Override
    public void run(LivingEntity entity, ItemStack stack, AttackActionHandler handler, AnimationState anim) {
        Vec3 dir;
        if (anim.isAt("move_1")) {
            dir = CombatUtils.fromRelativeVector((Entity)entity, new Vec3(0.0, 0.0, 1.0));
            handler.store(DataKey.MOVE_DIRECTION, dir.scale(0.5).add(0.0, 0.5, 0.0));
            entity.playSound((SoundEvent)RuneCraftorySounds.SPELL_GENERIC_LEAP.get(), 1.0f, (entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.2f + 1.2f);
        }
        if (anim.isAt("move_2")) {
            dir = CombatUtils.fromRelativeVector((Entity)entity, new Vec3(0.0, 0.0, 1.0));
            handler.store(DataKey.MOVE_DIRECTION, dir.scale(0.5));
        }
        if (anim.isAt("move_3")) {
            dir = CombatUtils.fromRelativeVector((Entity)entity, new Vec3(0.0, 0.0, 1.0));
            handler.store(DataKey.MOVE_DIRECTION, dir.scale(0.5).add(0.0, -0.5, 0.0));
        }
        if (anim.isAt("move_done")) {
            handler.store(DataKey.MOVE_DIRECTION, null);
        }
        handler.applyMoveDirection();
        if (anim.isPast("attack_start") && !anim.isPast("attack_end") && !entity.level().isClientSide) {
            if (anim.isAt("reset")) {
                handler.resetHitEntityTracker();
            }
            handler.addHitEntityTracker(CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.aabbTargets(entity.getBoundingBox().inflate(0.75).expandTowards(0.0, 0.0, 0.5))).withBonusAttributesMultiplier((Holder<Attribute>)Attributes.ATTACK_DAMAGE, CombatUtils.getAbilityDamageBonus(stack, RuneCraftorySpells.AXEL_DISASTER)).withTargetPredicate(e -> !handler.getHitEntityTracker().contains(e)).executeAttack());
        }
    }

    @Override
    public boolean isInvulnerable(LivingEntity entity, AttackActionHandler handler) {
        return true;
    }

    @Override
    public Pose getPose(LivingEntity entity, AttackActionHandler handler) {
        if (handler.getAnimation().isPast("move_1") && !handler.getAnimation().isPast("move_done")) {
            return Pose.SPIN_ATTACK;
        }
        return null;
    }

    @Override
    public boolean usableOnMounts(int targetCombo) {
        return false;
    }
}

