/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attackactions;

import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.runecraftory.api.registry.action.AttackAction;
import io.github.flemmli97.runecraftory.api.registry.action.ComboContainer;
import io.github.flemmli97.runecraftory.api.registry.action.DataKey;
import io.github.flemmli97.runecraftory.api.registry.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.common.attachment.AttackActionHandler;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.item.AOEWeapon;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class GloveAttack
extends AttackAction {
    private final ComboContainer combo = ComboContainer.Builder.builder().addCombo(ComboContainer.past("done"), 2).addCombo(ComboContainer.past("done"), 2).addCombo(ComboContainer.past("done"), 2).addCombo(handler -> handler.isCurrentAnimationDone() && CombatUtils.canPerform(handler.getEntity(), Skills.FIST, 20), 0).build();

    @Override
    public AnimationState getAnimation(LivingEntity entity, int comboIdx) {
        float speed = (float)EntityUtils.attackSpeedModifier(entity);
        return AttackAction.create(PlayerModelAnimations.GLOVES.get(comboIdx), speed);
    }

    @Override
    public void run(LivingEntity entity, ItemStack stack, AttackActionHandler handler, AnimationState anim) {
        if (anim.isAt("attack") && handler.getComboCount() != 5) {
            if (!entity.level().isClientSide) {
                if (handler.getComboCount() != 4) {
                    CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.obbTargets(AOEWeapon.createOBB((LivingEntity)entity, (double)CombatUtils.getRange(entity, 0.0), (double)CombatUtils.getWidth(entity, 0.0), (double)0.5))).executeAttack();
                } else {
                    CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.aabbTargets(new AABB(-1.0, -1.0, -1.0, 1.0, 1.5, 1.5).move(entity.position().add(0.0, 0.2, 0.0).add(entity.getDeltaMovement().normalize().scale(0.4))))).executeAttack();
                }
            }
            entity.playSound(SoundEvents.PLAYER_ATTACK_STRONG, 1.0f, (entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.2f + 1.0f);
        }
        switch (handler.getComboCount()) {
            case 1: {
                if (!anim.isAt("step")) break;
                Vec3 dir = CombatUtils.fromRelativeVector((Entity)entity, new Vec3(0.0, 0.0, 1.0));
                entity.setDeltaMovement(dir.scale(0.2));
                break;
            }
            case 2: 
            case 3: {
                if (!anim.isAt("step")) break;
                Vec3 dir = CombatUtils.fromRelativeVector((Entity)entity, new Vec3(0.0, 0.0, 1.0));
                entity.setDeltaMovement(dir.scale(0.3));
                break;
            }
            case 4: {
                Vec3 dir;
                if (anim.isAt("jump")) {
                    dir = CombatUtils.fromRelativeVector((Entity)entity, new Vec3(0.0, 0.0, 1.0));
                    entity.setDeltaMovement(dir.scale(1.2).add(0.0, 0.9, 0.0));
                }
                if (anim.isAt("down")) {
                    dir = CombatUtils.fromRelativeVector((Entity)entity, new Vec3(0.0, 0.0, 1.0));
                    entity.setDeltaMovement(dir.scale(0.9).add(0.0, -0.5, 0.0));
                }
                entity.resetFallDistance();
                break;
            }
            case 5: {
                if (anim.isAt("leap")) {
                    handler.store(DataKey.SPIN_ROTATION, Float.valueOf(entity.getYRot()));
                    handler.resetHitEntityTracker();
                    Vec3 dir = CombatUtils.fromRelativeVector(handler.get(DataKey.SPIN_ROTATION).floatValue(), new Vec3(0.0, 0.0, 1.0));
                    entity.setDeltaMovement(dir.scale(2.7).add(0.0, 0.6, 0.0));
                }
                entity.resetFallDistance();
                if (anim.isAt("attack_start")) {
                    entity.playSound((SoundEvent)RuneCraftorySounds.SPELL_GENERIC_WIND_LONG.get(), 1.0f, (entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.2f + 1.3f);
                }
                if (entity.level().isClientSide || !anim.isPast("attack_start") || anim.isPast("attack_end")) break;
                handler.addHitEntityTracker(CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.aabbTargets(entity.getBoundingBox().inflate(0.5))).withTargetPredicate(e -> !handler.getHitEntityTracker().contains(e)).executeAttack());
            }
        }
        if (handler.getComboCount() == 5) {
            handler.store(DataKey.FIXED_LOOK, anim.isPast("move_start") && !anim.isPast("move_end"));
        }
    }

    @Override
    public void onStart(LivingEntity entity, AttackActionHandler handler) {
        if (handler.getComboCount() == 5 && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            LevelCalc.useRP(Platform.INSTANCE.getPlayerData((Player)player), GeneralConfig.gloveUltimate, true, 0.0f, false, new Skills[0]);
        }
    }

    @Override
    public boolean isInvulnerable(LivingEntity entity, AttackActionHandler handler) {
        return handler.getComboCount() == 5;
    }

    @Override
    public float movementReduction(AnimationState current) {
        return GeneralConfig.MOVE_SPEED_ATTACK.get().floatValue();
    }

    @Override
    public Pose getPose(LivingEntity entity, AttackActionHandler handler) {
        if (handler.getAnimation() == null) {
            return null;
        }
        if (handler.getComboCount() == 5 && handler.getAnimation().isPast("attack_start") && !handler.getAnimation().isPast("attack_end")) {
            return Pose.SPIN_ATTACK;
        }
        return null;
    }

    @Override
    public ComboContainer combos() {
        return this.combo;
    }

    @Override
    public boolean usableOnMounts(int targetCombo) {
        return targetCombo < 4;
    }
}

