/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attackactions;

import io.github.flemmli97.runecraftory.api.registry.action.AttackAction;
import io.github.flemmli97.runecraftory.api.registry.action.ComboContainer;
import io.github.flemmli97.runecraftory.api.registry.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.common.attachment.AttackActionHandler;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class NaiveBladeAttack
extends AttackAction {
    private final ComboContainer combo = ComboContainer.Builder.builder().addCombo(handler -> handler.getAnimation().isPast("prepared")).build();

    @Override
    public AnimationState getAnimation(LivingEntity entity, int comboIdx) {
        float speed = (float)EntityUtils.attackSpeedModifier(entity);
        if (comboIdx == 1) {
            return AttackAction.create(PlayerModelAnimations.NAIVE_BLADE_SUCCESS, speed);
        }
        return AttackAction.create(PlayerModelAnimations.NAIVE_BLADE, speed);
    }

    @Override
    public void run(LivingEntity entity, ItemStack stack, AttackActionHandler handler, AnimationState anim) {
        if (handler.getComboCount() == 2) {
            if (anim.isAt("jump")) {
                entity.setDeltaMovement(new Vec3(0.0, 0.37, 0.0));
            }
            if (anim.isAt("attack_1")) {
                entity.playSound((SoundEvent)RuneCraftorySounds.PLAYER_ATTACK_SWOOSH.get(), 1.0f, (entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.2f + 1.0f);
                if (!entity.level().isClientSide) {
                    CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.circleTargets(entity.getYRot() - 150.0f, entity.getYRot() + 150.0f, 0.0f)).withBonusAttributesMultiplier((Holder<Attribute>)Attributes.ATTACK_DAMAGE, CombatUtils.getAbilityDamageBonus(stack, RuneCraftorySpells.NAIVE_BLADE)).doOnSuccess(target -> CombatUtils.knockBackEntity(entity, target, 1.3f)).executeAttack();
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)entity;
                        player.sweepAttack();
                    }
                }
            }
            if (anim.isAt("attack_2")) {
                entity.playSound((SoundEvent)RuneCraftorySounds.PLAYER_ATTACK_SWOOSH.get(), 1.0f, (entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.2f + 1.0f);
                if (!entity.level().isClientSide) {
                    CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.obbTargets(entity.getYRot(), 0.0f, 3.0, 0.0, false)).withBonusAttributesMultiplier((Holder<Attribute>)Attributes.ATTACK_DAMAGE, CombatUtils.getAbilityDamageBonus(stack, RuneCraftorySpells.NAIVE_BLADE)).executeAttack();
                }
            }
        } else if (anim.isAt("prepared")) {
            entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.CHAIN_PLACE, entity.getSoundSource(), 1.5f, (entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.2f + 1.0f);
        }
    }

    @Override
    public void onStart(LivingEntity entity, AttackActionHandler handler) {
        super.onStart(entity, handler);
        if (handler.getComboCount() == 2) {
            entity.playSound((SoundEvent)RuneCraftorySounds.SPELL_NAIVE_BLADE.get(), 1.0f, (entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.2f + 1.0f);
        }
    }

    @Override
    public boolean isInvulnerable(LivingEntity entity, AttackActionHandler handler) {
        return handler.getComboCount() == 2;
    }

    public static boolean canCounter(AttackActionHandler handler) {
        AnimationState anim = handler.getAnimation();
        return handler.getCurrentAction() instanceof NaiveBladeAttack && anim != null && handler.getComboCount() == 1 && anim.isPast("prepared") && !anim.done(0);
    }

    @Override
    public ComboContainer combos() {
        return this.combo;
    }
}

