/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attackactions;

import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.runecraftory.api.registry.action.AttackAction;
import io.github.flemmli97.runecraftory.api.registry.action.ComboContainer;
import io.github.flemmli97.runecraftory.api.registry.action.DataKey;
import io.github.flemmli97.runecraftory.api.registry.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.common.attachment.AttackActionHandler;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.item.AOEWeapon;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SpearAttack
extends AttackAction {
    private final ComboContainer combo = ComboContainer.Builder.builder().addCombo(ComboContainer.past("done"), 2).addCombo(ComboContainer.past("done"), 2).addCombo(ComboContainer.past("done"), 2).addCombo(handler -> handler.isCurrentAnimationDone() && CombatUtils.canPerform(handler.getEntity(), Skills.SPEAR, 20), 0).build();

    @Override
    public AnimationState getAnimation(LivingEntity entity, int comboIdx) {
        float speed = (float)EntityUtils.attackSpeedModifier(entity);
        return AttackAction.create(PlayerModelAnimations.SPEAR.get(comboIdx), speed);
    }

    @Override
    public void run(LivingEntity entity, ItemStack stack, AttackActionHandler handler, AnimationState anim) {
        if (handler.getComboCount() != 5 && anim.isAt("attack")) {
            if (!entity.level().isClientSide) {
                CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.obbTargets(AOEWeapon.createOBB((LivingEntity)entity, (double)CombatUtils.getRange(entity, 0.0), (double)CombatUtils.getWidth(entity, 0.0), (double)0.5))).executeAttack();
            }
            entity.playSound((SoundEvent)RuneCraftorySounds.PLAYER_ATTACK_SWOOSH_LIGHT.get(), 1.0f, (entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.2f + 1.0f);
        }
        Vec3 dir = CombatUtils.fromRelativeVector((Entity)entity, new Vec3(0.0, 0.0, 1.0));
        switch (handler.getComboCount()) {
            case 1: 
            case 3: 
            case 4: {
                if (!anim.isAt("step")) break;
                entity.setDeltaMovement(dir.scale(0.3));
                break;
            }
            case 2: {
                if (!anim.isAt("step")) break;
                entity.setDeltaMovement(dir.scale(0.15));
                break;
            }
            case 5: {
                CombatUtils.EntityAttack attack;
                if (anim.isAt("spin_start")) {
                    handler.store(DataKey.SPIN_ROTATION, Float.valueOf(entity.getYRot()));
                    handler.resetHitEntityTracker();
                    entity.playSound((SoundEvent)RuneCraftorySounds.PLAYER_ATTACK_SWOOSH.get(), 1.0f, (entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.2f + 1.0f);
                }
                if (anim.isAt("reset")) {
                    handler.resetHitEntityTracker();
                    entity.playSound((SoundEvent)RuneCraftorySounds.PLAYER_ATTACK_SWOOSH.get(), 1.0f, (entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.2f + 1.0f);
                }
                if ((attack = SpearAttack.spinAttack(entity, anim, anim.getMarker("spin_start", 0), anim.getMarker("spin_end", 0), handler.get(DataKey.SPIN_ROTATION).floatValue() + 180.0f, handler.get(DataKey.SPIN_ROTATION).floatValue() + 1260.0f, -1.0f)) != null) {
                    handler.addHitEntityTracker(attack.withTargetPredicate(e -> !handler.getHitEntityTracker().contains(e)).executeAttack());
                }
                if (anim.isAt("leap")) {
                    entity.setDeltaMovement(dir.scale(1.3).add(0.0, 0.4, 0.0));
                }
                if (!anim.isAt("slam")) break;
                Vec3 look = entity.getLookAngle();
                look = new Vec3(look.x(), 0.0, look.z()).scale(1.2);
                Vec3 attackPos = entity.position().add(0.0, 0.2, 0.0).add(look);
                CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.aabbTargets(new AABB(-1.0, -1.2, 0.0, 1.0, 1.2, 2.5), false)).executeAttack();
                Vec3 pos = entity.position().add(0.0, -1.0, 0.0);
                BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
                Vec3 particlePos = new Vec3(0.0, 0.0, 1.0);
                for (int i = -180; i < 180; i += 15) {
                    Level level;
                    Vec3 scaled = particlePos.yRot((float)i * ((float)Math.PI / 180));
                    mut.set(Mth.floor((double)(pos.x() + particlePos.x())), Mth.floor((double)pos.y()), Mth.floor((double)(pos.z() + particlePos.z())));
                    BlockState state = entity.level().getBlockState((BlockPos)mut);
                    if (state.getRenderShape() == RenderShape.INVISIBLE || !((level = entity.level()) instanceof ServerLevel)) continue;
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, state), attackPos.x() + scaled.x() + entity.getDeltaMovement().x(), entity.getY() + 0.1, attackPos.z() + scaled.z() + entity.getDeltaMovement().z(), 0, (double)((float)scaled.x()), 1.5, (double)((float)scaled.z()), 1.0);
                }
                entity.playSound(SoundEvents.DRAGON_FIREBALL_EXPLODE, 1.0f, (entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.2f + 1.0f);
            }
        }
        if (handler.getComboCount() == 5) {
            handler.store(DataKey.FIXED_LOOK, anim.isPast("leap") && !anim.isPast("leap_end"));
        }
    }

    @Override
    public void onStart(LivingEntity entity, AttackActionHandler handler) {
        if (handler.getComboCount() == 5 && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            LevelCalc.useRP(Platform.INSTANCE.getPlayerData((Player)player), GeneralConfig.spearUltimate, true, 0.0f, false, new Skills[0]);
        }
    }

    @Override
    public boolean isInvulnerable(LivingEntity entity, AttackActionHandler handler) {
        return handler.getComboCount() == 5;
    }

    @Override
    public float movementReduction(AnimationState current) {
        return GeneralConfig.MOVE_SPEED_ATTACK.get().floatValue();
    }

    @Override
    public ComboContainer combos() {
        return this.combo;
    }

    @Override
    public boolean usableOnMounts(int targetCombo) {
        return targetCombo != 5;
    }
}

