/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attackactions;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.api.registry.action.AttackAction;
import io.github.flemmli97.runecraftory.api.registry.action.ComboContainer;
import io.github.flemmli97.runecraftory.api.registry.action.DataKey;
import io.github.flemmli97.runecraftory.api.registry.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.common.attachment.AttackActionHandler;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemSpell;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class WaterLaserAttack
extends AttackAction {
    private final ComboContainer combo = ComboContainer.Builder.builder().addCombo(handler -> true, 0).build();
    private final int type;

    public WaterLaserAttack(int type) {
        this.type = type;
    }

    @Override
    public AnimationState getAnimation(LivingEntity entity, int comboIdx) {
        float speed = (float)EntityUtils.attackSpeedModifier(entity);
        if (comboIdx == 1) {
            return AttackAction.create(PlayerModelAnimations.WATER_LASER_END, speed);
        }
        return switch (this.type) {
            case 2 -> AttackAction.create(PlayerModelAnimations.WATER_LASER_THREE, speed);
            case 1 -> AttackAction.create(PlayerModelAnimations.WATER_LASER_TWO, speed);
            default -> AttackAction.create(PlayerModelAnimations.WATER_LASER_ONE, speed);
        };
    }

    @Override
    public void run(LivingEntity entity, ItemStack stack, AttackActionHandler handler, AnimationState anim) {
        block6: {
            block7: {
                if (handler.getComboCount() != 1) break block6;
                Level level = entity.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    if (anim.isAt("attack")) {
                        Spell spell;
                        entity.swing(InteractionHand.MAIN_HAND);
                        if (handler.get(DataKey.USED_SPELL) != null && (spell = handler.get(DataKey.USED_SPELL)).use(serverLevel, entity, stack) && entity instanceof ServerPlayer) {
                            ServerPlayer player = (ServerPlayer)entity;
                            spell.levelSkill(player);
                        }
                    }
                }
                if (entity.level().isClientSide || !anim.isPast("continue")) break block6;
                if (!(entity instanceof ServerPlayer)) break block7;
                ServerPlayer player = (ServerPlayer)entity;
                if (!entity.getUseItem().isEmpty() || Platform.INSTANCE.getPlayerData((Player)player).getInv().getInUseStack() == handler.get(DataKey.USED_WEAPON)) break block6;
            }
            handler.doWeaponAttack(this, handler.get(DataKey.USED_WEAPON), handler.get(DataKey.USED_SPELL));
        }
    }

    @Override
    public AttackAction onChange(LivingEntity entity, AttackActionHandler handler) {
        if (handler.getComboCount() == 1) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                Spell spell = handler.get(DataKey.USED_SPELL);
                ItemStack stack = handler.get(DataKey.USED_WEAPON);
                if (stack.getItem() instanceof ItemSpell) {
                    player.getCooldowns().addCooldown(stack.getItem(), spell.properties().cooldown());
                }
            }
            return this;
        }
        return null;
    }

    @Override
    public boolean disableItemSwitch() {
        return false;
    }

    @Override
    public ComboContainer combos() {
        return this.combo;
    }
}

