/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.blocks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.loot.LootCtxParameters;
import io.github.flemmli97.runecraftory.common.utils.ItemComponentUtils;
import io.github.flemmli97.tenshilib.common.utils.CodecUtils;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HerbBlock
extends BushBlock {
    public static final MapCodec<HerbBlock> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)HerbBlock.propertiesCodec(), (App)CodecUtils.stringEnumCodec(GroundTypes.class, null).listOf().fieldOf("types").forGetter(d -> List.copyOf(d.types))).apply((Applicative)inst, (prop, types) -> new HerbBlock((BlockBehaviour.Properties)prop, (GroundTypes[])types.toArray(GroundTypes[]::new))));
    public static final VoxelShape SHAPE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0);
    public static final IntegerProperty LEVEL = IntegerProperty.create((String)"variant", (int)0, (int)10);
    private final Set<GroundTypes> types = EnumSet.noneOf(GroundTypes.class);

    public HerbBlock(BlockBehaviour.Properties props, GroundTypes ... types) {
        super(props);
        this.types.addAll(Arrays.asList(types));
    }

    public MapCodec<HerbBlock> codec() {
        return CODEC;
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        return super.getDrops(state, builder.withParameter(LootCtxParameters.ITEM_LEVEL_CONTEXT, (Object)((Integer)state.getValue((Property)LEVEL))));
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        if (this.types.contains((Object)GroundTypes.NETHER) && (state.is(BlockTags.BASE_STONE_NETHER) || state.is(BlockTags.NYLIUM))) {
            return true;
        }
        if (this.types.contains((Object)GroundTypes.END) && state.is(RunecraftoryTags.Blocks.ENDSTONES)) {
            return true;
        }
        if (this.types.contains((Object)GroundTypes.SANDY) && state.is(BlockTags.SAND)) {
            return true;
        }
        return state.is(BlockTags.DIRT) || state.is(RunecraftoryTags.Blocks.FARMLAND) || super.mayPlaceOn(state, level, pos);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Vec3 vector3d = state.getOffset(level, pos);
        return SHAPE.move(vector3d.x, vector3d.y, vector3d.z);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)LEVEL, (Comparable)Integer.valueOf(ItemComponentUtils.itemLevel(context.getItemInHand())));
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return ItemComponentUtils.getLeveledItem(super.getCloneItemStack(level, pos, state), 1);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LEVEL});
    }

    public static enum GroundTypes {
        NETHER,
        END,
        SANDY;

    }
}

