/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.blocks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.common.blocks.TreeLeavesBlock;
import io.github.flemmli97.runecraftory.common.blocks.util.LazyResolvedRegistryEntry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class TreeFruitLeavesBlock
extends TreeLeavesBlock {
    public static final MapCodec<TreeFruitLeavesBlock> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)TreeFruitLeavesBlock.propertiesCodec(), (App)LazyResolvedRegistryEntry.codec(Registries.ITEM).fieldOf("fruit").forGetter(d -> d.fruit)).apply((Applicative)inst, TreeFruitLeavesBlock::new));
    public static final BooleanProperty HAS_FRUIT = BooleanProperty.create((String)"has_fruit");
    private final LazyResolvedRegistryEntry<Item> fruit;

    public TreeFruitLeavesBlock(BlockBehaviour.Properties properties, ResourceKey<Item> fruit) {
        this(properties, new LazyResolvedRegistryEntry<Item>(fruit));
    }

    private TreeFruitLeavesBlock(BlockBehaviour.Properties properties, LazyResolvedRegistryEntry<Item> fruit) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)HAS_FRUIT, (Comparable)Boolean.valueOf(false)));
        this.fruit = fruit;
    }

    public MapCodec<TreeFruitLeavesBlock> codec() {
        return CODEC;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{HAS_FRUIT});
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        if (((Boolean)state.getValue((Property)HAS_FRUIT)).booleanValue()) {
            Block.popResource((Level)level, (BlockPos)pos.below(), (ItemStack)new ItemStack(this.fruit.get((HolderLookup.Provider)level.registryAccess())));
            level.setBlock(pos, (BlockState)state.setValue((Property)HAS_FRUIT, (Comparable)Boolean.valueOf(false)), 3);
            return ItemInteractionResult.CONSUME;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }
}

