/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.blocks.entity;

import com.mojang.serialization.DynamicOps;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class SingleTimeSpawner
extends BlockEntity {
    private EntityType<?> savedEntity;
    private ResourceLocation npcProfession;
    private CompoundTag tag;
    private int delay = 3;

    public SingleTimeSpawner(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RuneCraftoryBlocks.SINGLE_SPAWNER_TILE.get(), blockPos, blockState);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, SingleTimeSpawner blockEntity) {
        if (--blockEntity.delay > 0) {
            return;
        }
        if (blockEntity.savedEntity != null) {
            blockEntity.spawnEntity();
        }
        level.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 3);
    }

    private void spawnEntity() {
        Entity e;
        if (!this.level.isClientSide && (e = this.savedEntity.create(this.level)) != null) {
            if (e instanceof Mob) {
                Mob mob = (Mob)e;
                mob.finalizeSpawn((ServerLevelAccessor)this.level, this.level.getCurrentDifficultyAt(e.blockPosition()), MobSpawnType.SPAWNER, null);
            }
            if (e instanceof NPCEntity) {
                NPCEntity npc = (NPCEntity)e;
                npc.randomizeData(this.npcProfession);
            }
            e.moveTo((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY(), (double)this.worldPosition.getZ() + 0.5, this.level.random.nextFloat() * 360.0f, 0.0f);
            if (this.tag != null) {
                CompoundTag newTag = e.saveWithoutId(new CompoundTag());
                newTag.merge(this.tag);
                e.load(newTag);
            }
            this.level.addFreshEntity(e);
        }
    }

    public void setEntity(EntityType<?> entity, CompoundTag tag) {
        this.savedEntity = entity;
        this.tag = tag;
        if (this.tag != null && this.tag.hasUUID("UUID")) {
            this.tag.remove("UUID");
        }
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        this.savedEntity = (EntityType)BuiltInRegistries.ENTITY_TYPE.byNameCodec().parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)nbt.get("Entity")).getOrThrow();
        if (nbt.contains("EntityNBT")) {
            this.tag = nbt.getCompound("EntityNBT");
        }
        if (nbt.contains("NPCProfession")) {
            this.npcProfession = ResourceLocation.parse((String)nbt.getString("NPCProfession"));
        }
    }

    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.saveAdditional(nbt, provider);
        if (this.savedEntity != null) {
            nbt.put("Entity", (Tag)BuiltInRegistries.ENTITY_TYPE.byNameCodec().encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), this.savedEntity).getOrThrow());
        }
        if (this.tag != null) {
            nbt.put("EntityNBT", (Tag)this.tag);
        }
        if (this.npcProfession != null) {
            nbt.putString("NPCProfession", this.npcProfession.toString());
        }
    }
}

