/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.utils.StreamCodecUtils;
import it.unimi.dsi.fastutil.objects.Object2DoubleAVLTreeMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleSortedMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleSortedMaps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.ai.attributes.Attribute;

public class ItemAttributeData {
    public static final ItemAttributeData DEFAULT = new ItemAttributeData(Map.of(), Map.of());
    public static final Codec<ItemAttributeData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)BuiltInRegistries.ATTRIBUTE.holderByNameCodec(), (Codec)Codec.DOUBLE).fieldOf("base_stats").forGetter(d -> d.baseStats), (App)Codec.unboundedMap((Codec)BuiltInRegistries.ATTRIBUTE.holderByNameCodec(), (Codec)Codec.DOUBLE).fieldOf("stats").forGetter(d -> d.stats)).apply((Applicative)instance, ItemAttributeData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemAttributeData> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ItemAttributeData>(){

        public ItemAttributeData decode(RegistryFriendlyByteBuf buf) {
            return new ItemAttributeData((Map)StreamCodecUtils.ATTRIBUTE_CODEC.decode((Object)buf), (Map)StreamCodecUtils.ATTRIBUTE_CODEC.decode((Object)buf));
        }

        public void encode(RegistryFriendlyByteBuf buf, ItemAttributeData component) {
            StreamCodecUtils.ATTRIBUTE_CODEC.encode((Object)buf, component.baseStats);
            StreamCodecUtils.ATTRIBUTE_CODEC.encode((Object)buf, component.stats);
        }
    };
    private final Map<Holder<Attribute>, Double> baseStats;
    private final Map<Holder<Attribute>, Double> stats;
    private final Object2DoubleSortedMap<Holder<Attribute>> totalStats;

    private ItemAttributeData(Map<Holder<Attribute>, Double> baseStats, Map<Holder<Attribute>, Double> stats) {
        this.baseStats = baseStats;
        this.stats = stats;
        Object2DoubleAVLTreeMap map = new Object2DoubleAVLTreeMap(RuneCraftoryAttributes.SORTED);
        map.putAll(this.baseStats);
        this.stats.forEach((attribute, value) -> map.put(attribute, map.getOrDefault(attribute, 0.0) + value));
        this.totalStats = Object2DoubleSortedMaps.unmodifiable((Object2DoubleSortedMap)map);
    }

    public ItemAttributeData base(Map<Holder<Attribute>, Double> baseStats) {
        return new ItemAttributeData(baseStats, this.getStats());
    }

    public ItemAttributeData add(Map<Holder<Attribute>, Double> stats) {
        HashMap<Holder<Attribute>, Double> map = new HashMap<Holder<Attribute>, Double>(this.stats);
        stats.forEach((attribute, value) -> map.put((Holder<Attribute>)attribute, map.getOrDefault(attribute, 0.0) + value));
        return new ItemAttributeData(this.getBaseStats(), map);
    }

    public Map<Holder<Attribute>, Double> getBaseStats() {
        return Map.copyOf(this.baseStats);
    }

    public Map<Holder<Attribute>, Double> getStats() {
        return Map.copyOf(this.stats);
    }

    public Map<Holder<Attribute>, Double> getTotalStats() {
        return this.totalStats;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ItemAttributeData) {
            ItemAttributeData other = (ItemAttributeData)object;
            return this.baseStats.equals(other.baseStats) && this.stats.equals(other.stats);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.baseStats, this.stats);
    }
}

