/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public class ListItemStackHolder
implements Iterable<ItemStack> {
    public static final ListItemStackHolder DEFAULT = new ListItemStackHolder(List.of());
    public static final Codec<ListItemStackHolder> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.CODEC.listOf().fieldOf("stacks").forGetter(d -> d.stacks)).apply((Applicative)instance, ListItemStackHolder::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ListItemStackHolder> STREAM_CODEC = ByteBufCodecs.list().apply(ItemStack.STREAM_CODEC).map(ListItemStackHolder::new, holder -> holder.stacks);
    private final List<ItemStack> stacks;

    public ListItemStackHolder(List<ItemStack> stacks) {
        this.stacks = stacks.stream().map(ItemStack::copy).toList();
    }

    public ListItemStackHolder add(ItemStack add) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(this.stacks);
        stacks.add(add.copy());
        return new ListItemStackHolder(stacks);
    }

    public int matchesItem(ItemStack other) {
        int matches = 0;
        for (ItemStack stack : this.stacks) {
            if (!ItemStack.isSameItem((ItemStack)stack, (ItemStack)other)) continue;
            ++matches;
        }
        return matches;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ListItemStackHolder) {
            ListItemStackHolder other = (ListItemStackHolder)object;
            return this.stacks.equals(other.stacks);
        }
        return false;
    }

    public int hashCode() {
        return this.stacks.hashCode();
    }

    @Override
    public Iterator<ItemStack> iterator() {
        return this.stacks.stream().map(ItemStack::copy).iterator();
    }
}

