/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.datapack.manager.npc;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.datapack.npc.ConversationSet;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.datapack.ListenerExtension;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class NPCConversationManager
extends SimpleJsonResourceReloadListener
implements ListenerExtension {
    public static final ResourceLocation ID = RuneCraftory.modRes("conversation");
    public static final String DIRECTORY = String.format("%s/%s", ID.getNamespace(), ID.getPath());
    private Map<ResourceLocation, ConversationSet> data = ImmutableMap.of();
    private HolderLookup.Provider provider;

    public NPCConversationManager() {
        super(DataPackHandler.GSON, DIRECTORY);
    }

    public ConversationSet get(ResourceLocation res, ConversationSet fallback) {
        return this.data.getOrDefault(res, fallback);
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        RegistryOps ops = this.provider.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
        map.forEach((arg_0, arg_1) -> NPCConversationManager.lambda$apply$0(builder, (DynamicOps)ops, arg_0, arg_1));
        this.data = builder.build();
    }

    @Override
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void insertRegistryAccess(HolderLookup.Provider provider) {
        this.provider = provider;
    }

    private static /* synthetic */ void lambda$apply$0(ImmutableMap.Builder builder, DynamicOps ops, ResourceLocation fres, JsonElement el) {
        try {
            JsonObject obj = el.getAsJsonObject();
            builder.put((Object)fres, (Object)((ConversationSet)ConversationSet.CODEC.parse(ops, (Object)obj).getOrThrow()));
        }
        catch (Exception ex) {
            RuneCraftory.LOGGER.error("Couldn't parse npc data json {} {}", (Object)fres, (Object)ex);
            ex.fillInStackTrace();
        }
    }
}

