/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.effects;

import io.github.flemmli97.runecraftory.common.effects.UncurableEffect;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.utils.DamageSourceUtils;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;

public class PoisonEffect
extends UncurableEffect {
    public PoisonEffect() {
        super(MobEffectCategory.HARMFUL, 1395208, eff -> ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)0));
    }

    public boolean applyEffectTick(LivingEntity living, int amplifier) {
        float amount = living.getMaxHealth() * 0.05f;
        float f = amount = living.getHealth() - amount < 1.0f ? living.getHealth() - 1.0f : amount;
        if (living.getType().is(RunecraftoryTags.EntityTypes.BOSSES)) {
            amount = (float)((double)amount * 0.25);
        }
        if (amount > 0.0f) {
            living.hurt(DamageSourceUtils.poison(living.level()), amount);
        }
        return super.applyEffectTick(living, amplifier);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return duration % 60 == 0;
    }
}

