/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities;

import com.mojang.serialization.DynamicOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.common.attachment.player.XpLevelHolder;
import io.github.flemmli97.runecraftory.common.config.MobConfig;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.misc.TreasureChestEntity;
import io.github.flemmli97.runecraftory.common.entities.utils.IBaseMob;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class GateEntity
extends Mob
implements IBaseMob {
    private static final Map<ItemElement, ResourceKey<LootTable>> LOOT_RES = new HashMap<ItemElement, ResourceKey<LootTable>>();
    private static final EntityDataAccessor<String> ELEMENT_TYPE = SynchedEntityData.defineId(GateEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Integer> ELEMENT = SynchedEntityData.defineId(GateEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> MOB_LEVEL = SynchedEntityData.defineId(GateEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final ResourceLocation ATTRIBUTE_LEVEL_MOD = RuneCraftory.modRes("gate_level_modifier");
    public int rotate;
    public int clientRenderTick;
    private final List<EntityType<?>> spawnList = new ArrayList();
    private ItemElement type = ItemElement.NONE;
    private boolean initialSpawn = true;
    private final XpLevelHolder expPair = new XpLevelHolder();
    private boolean removeCauseEmptyList;
    private int maxNearby;
    private int spawnDelay;
    public final int renderRand = this.random.nextInt(1000);

    public GateEntity(EntityType<? extends GateEntity> type, Level level) {
        super(type, level);
        if (level.isClientSide) {
            this.rotate = level.random.nextInt(2) == 0 ? 1 : -1;
        }
        this.updateAttributes();
        this.setNoGravity(true);
        this.maxNearby = this.getRandom().nextInt(1 + MobConfig.maxNearby - MobConfig.minNearby) + MobConfig.minNearby;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(RuneCraftoryAttributes.DEFENCE.asHolder()).add(RuneCraftoryAttributes.MAGIC_DEFENCE.asHolder()).add(RuneCraftoryAttributes.WATER_RESISTANCE.asHolder()).add(RuneCraftoryAttributes.EARTH_RESISTANCE.asHolder()).add(RuneCraftoryAttributes.WIND_RESISTANCE.asHolder()).add(RuneCraftoryAttributes.FIRE_RESISTANCE.asHolder()).add(RuneCraftoryAttributes.DARK_RESISTANCE.asHolder()).add(RuneCraftoryAttributes.LIGHT_RESISTANCE.asHolder()).add(RuneCraftoryAttributes.LOVE_RESISTANCE.asHolder());
    }

    public static boolean gateSpawnRules(EntityType<? extends Mob> type, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, BlockState state, RandomSource random) {
        BlockPos blockPos = pos.below();
        return spawnType == MobSpawnType.SPAWNER || level.getBlockState(blockPos).isValidSpawn((BlockGetter)level, blockPos, type) || level.getSeaLevel() - 5 > pos.getY() && state.getFluidState().is(FluidTags.WATER);
    }

    public static boolean canSpawnAt(EntityType<? extends GateEntity> type, ServerLevelAccessor level, MobSpawnType reason, BlockPos pos, RandomSource random) {
        BlockState state = level.getBlockState(pos);
        return level.getDifficulty() != Difficulty.PEACEFUL && DataPackHandler.INSTANCE.gateSpawnsManager().hasSpawns(level, pos, state) && level.getLevel().getPoiManager().find(holder -> holder.is(PoiTypes.MEETING), p -> true, pos, MobConfig.bellRadius, PoiManager.Occupancy.ANY).isEmpty() && GateEntity.gateSpawnRules(type, (LevelAccessor)level, reason, pos, state, random) && level.getEntitiesOfClass(GateEntity.class, new AABB(pos).inflate(MobConfig.minDist)).size() < MobConfig.maxGroup;
    }

    public static ResourceKey<LootTable> getGateLootLocation(ItemElement element) {
        ResourceKey def = ((EntityType)RuneCraftoryEntities.GATE.get()).getDefaultLootTable();
        return LOOT_RES.computeIfAbsent(element, e -> ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)def.location().getNamespace(), (String)(def.location().getPath() + "_" + e.name().toLowerCase(Locale.ROOT)))));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ELEMENT_TYPE, (Object)"none");
        builder.define(MOB_LEVEL, (Object)1);
        builder.define(ELEMENT, (Object)0);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (this.level().isClientSide) {
            if (key.equals(MOB_LEVEL)) {
                this.updateStatsToLevel();
            }
            if (key.equals(ELEMENT)) {
                this.type = ItemElement.values()[(Integer)this.entityData.get(ELEMENT)];
            }
        }
    }

    private void updateAttributes() {
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(MobConfig.gateHealth);
        this.getAttribute(RuneCraftoryAttributes.DEFENCE.asHolder()).setBaseValue(MobConfig.gateDef);
        this.getAttribute(RuneCraftoryAttributes.MAGIC_DEFENCE.asHolder()).setBaseValue(MobConfig.gateMDef);
        this.setHealth(this.getMaxHealth());
    }

    public boolean checkSpawnObstruction(LevelReader level) {
        return level.isUnobstructed((Entity)this);
    }

    public ItemElement getElement() {
        return this.type;
    }

    public void tick() {
        if (Platform.INSTANCE.entityTickPre((LivingEntity)this)) {
            return;
        }
        if (!this.level().isClientSide) {
            if (this.removeCauseEmptyList) {
                this.discard();
                return;
            }
            this.setSharedFlag(6, this.isCurrentlyGlowing());
        } else {
            this.clientRenderTick += 10;
        }
        this.baseTick();
        if (this.lerpSteps > 0) {
            double d0 = this.getX() + (this.lerpX - this.getX()) / (double)this.lerpSteps;
            double d2 = this.getY() + (this.lerpY - this.getY()) / (double)this.lerpSteps;
            double d4 = this.getZ() + (this.lerpZ - this.getZ()) / (double)this.lerpSteps;
            double d6 = Mth.wrapDegrees((double)(this.lerpYRot - (double)this.getYRot()));
            this.setYRot((float)((double)this.getYRot() + d6 / (double)this.lerpSteps));
            this.setXRot((float)((double)this.getXRot() + (this.lerpXRot - (double)this.getXRot()) / (double)this.lerpSteps));
            --this.lerpSteps;
            this.setPos(d0, d2, d4);
            this.setRot(this.getYRot(), this.getXRot());
        } else if (!this.isEffectiveAi()) {
            this.setDeltaMovement(this.getDeltaMovement().scale(0.98));
        }
        if (!this.level().isClientSide && --this.spawnDelay <= 0 && this.level().getDifficulty() != Difficulty.PEACEFUL) {
            int n = this.spawnDelay = MobConfig.minSpawnDelay >= MobConfig.maxSpawnDelay ? MobConfig.minSpawnDelay : this.getRandom().nextInt(MobConfig.minSpawnDelay, MobConfig.maxSpawnDelay);
            if (this.spawnMobs(1)) {
                this.spawnDelay = (int)((double)this.spawnDelay * 0.4);
            }
        }
    }

    private boolean spawnMobs(int count) {
        List nearby;
        ServerLevel serverLevel;
        Level level = this.level();
        if (!(level instanceof ServerLevel) || (serverLevel = (ServerLevel)level).getDifficulty() == Difficulty.PEACEFUL) {
            return false;
        }
        if (!this.spawnList.isEmpty() && (nearby = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(18.0), entity -> entity.getType() == RuneCraftoryEntities.TREASURE_CHEST.get() || entity.getType() == RuneCraftoryEntities.MONSTER_BOX.get() || entity.getType() == RuneCraftoryEntities.GOBBLE_BOX.get() || this.spawnList.contains(entity.getType()))).size() <= this.maxNearby) {
            for (int amount = 0; amount < count; ++amount) {
                BlockState state;
                boolean notSolid;
                Entity entity2;
                double x = this.getX() + (double)this.random.nextInt(9) - 4.0;
                double y = this.getY() + (double)this.random.nextInt(2) - 1.0;
                double z = this.getZ() + (double)this.random.nextInt(9) - 4.0;
                int levelRand = LevelCalc.randomizedLevel(this.random, (Integer)this.entityData.get(MOB_LEVEL));
                EntityType<?> type = this.spawnList.get(this.random.nextInt(this.spawnList.size()));
                if (this.initialSpawn) {
                    this.initialSpawn = false;
                    EntityType<?> chest = EntityUtils.trySpawnTreasureChest(this);
                    if (chest != null) {
                        type = chest;
                    }
                }
                if ((entity2 = type.create(this.level())) instanceof TreasureChestEntity) {
                    TreasureChestEntity chest = (TreasureChestEntity)entity2;
                    entity2.absMoveTo(x, y, z, this.level().random.nextFloat() * 360.0f, 0.0f);
                    if (!this.level().noCollision((Entity)chest)) continue;
                    EntityUtils.tieredTreasureChest(this, chest);
                    this.level().addFreshEntity(entity2);
                    continue;
                }
                if (!(entity2 instanceof Mob)) continue;
                Mob mob = (Mob)entity2;
                BlockPos pos = BlockPos.containing((double)x, (double)y, (double)z);
                while ((notSolid = !(state = this.level().getBlockState(pos.below())).entityCanStandOnFace((BlockGetter)this.level(), pos, entity2, Direction.UP) && !state.getFluidState().is(FluidTags.WATER)) && pos.distToCenterSqr(x, y, z) < 16.0) {
                    pos = pos.below();
                }
                if (notSolid) continue;
                if (mob instanceof BaseMonster) {
                    ((BaseMonster)mob).setXPLevel(levelRand);
                }
                entity2.absMoveTo(x, y, z, this.level().random.nextFloat() * 360.0f, 0.0f);
                if (!Platform.INSTANCE.checkSpawnPosition(mob, serverLevel, MobSpawnType.SPAWNER) || !this.level().noCollision((Entity)mob)) continue;
                mob.finalizeSpawn((ServerLevelAccessor)serverLevel, this.level().getCurrentDifficultyAt(mob.blockPosition()), MobSpawnType.SPAWNER, null);
                AttributeInstance follow = mob.getAttribute(Attributes.FOLLOW_RANGE);
                mob.restrictTo(this.blockPosition(), (int)Math.max(18.0, follow != null ? follow.getValue() * 0.75 : 0.0));
                this.level().addFreshEntity(entity2);
                mob.spawnAnim();
            }
            return true;
        }
        return false;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("MobLevel", ((Integer)this.entityData.get(MOB_LEVEL)).intValue());
        compound.put("Spawns", (Tag)BuiltInRegistries.ENTITY_TYPE.byNameCodec().listOf().encodeStart((DynamicOps)NbtOps.INSTANCE, this.spawnList).getOrThrow());
        compound.putString("Element", this.type.toString());
        compound.putBoolean("FirstSpawn", this.initialSpawn);
        compound.putInt("MaxNearby", this.maxNearby);
        compound.putInt("SpawnDelay", this.spawnDelay);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("MobLevel")) {
            this.entityData.set(MOB_LEVEL, (Object)compound.getInt("MobLevel"));
        }
        this.spawnList.clear();
        if (compound.contains("Spawns")) {
            this.spawnList.addAll((Collection)BuiltInRegistries.ENTITY_TYPE.byNameCodec().listOf().parse((DynamicOps)NbtOps.INSTANCE, (Object)compound.get("Spawns")).getOrThrow());
        }
        if (compound.contains("Element")) {
            String el = compound.getString("Element");
            try {
                this.type = ItemElement.valueOf(el);
                this.entityData.set(ELEMENT_TYPE, (Object)this.type.getTranslation());
                this.entityData.set(ELEMENT, (Object)this.type.ordinal());
            }
            catch (IllegalArgumentException e) {
                RuneCraftory.LOGGER.error("Unable to set element type for gate entity {}", (Object)this);
            }
        }
        this.initialSpawn = compound.getBoolean("FirstSpawn");
        this.maxNearby = compound.getInt("MaxNearby");
        this.spawnDelay = compound.getInt("SpawnDelay");
    }

    @Override
    public XpLevelHolder xpLevel() {
        this.expPair.setLevel((Integer)this.entityData.get(MOB_LEVEL), l -> 0);
        return this.expPair;
    }

    @Override
    public int friendPoints(UUID uuid) {
        return -1;
    }

    @Override
    public void setXPLevel(int lvl) {
        this.entityData.set(MOB_LEVEL, (Object)Mth.clamp((int)lvl, (int)1, (int)10000));
        this.updateStatsToLevel();
    }

    @Override
    public int baseXP() {
        return MobConfig.gateXp;
    }

    @Override
    public int baseMoney() {
        return MobConfig.gateMoney;
    }

    @Override
    public boolean applyFoodEffect(ItemStack stack) {
        return false;
    }

    @Override
    public void removeFoodEffect() {
    }

    protected ResourceKey<LootTable> getDefaultLootTable() {
        return GateEntity.getGateLootLocation(this.getElement());
    }

    public Iterable<ItemStack> getArmorSlots() {
        return NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    }

    public ItemStack getItemBySlot(EquipmentSlot slotIn) {
        return ItemStack.EMPTY;
    }

    public void setItemSlot(EquipmentSlot slotIn, ItemStack stack) {
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData) {
        Holder biome = level.getBiome(this.blockPosition());
        this.type = this.getType(level, (Holder<Biome>)biome);
        LevelCalc.GateLevelResult gateLevel = LevelCalc.levelFromPos(level.getLevel(), this.position());
        this.entityData.set(MOB_LEVEL, (Object)gateLevel.level());
        this.entityData.set(ELEMENT_TYPE, (Object)this.type.getTranslation());
        this.entityData.set(ELEMENT, (Object)this.type.ordinal());
        this.spawnList.addAll(DataPackHandler.INSTANCE.gateSpawnsManager().pickRandomMobs(level.getLevel(), this, (Holder<Biome>)biome, this.random, this.random.nextInt(3) + 1, this.blockPosition(), gateLevel.nearby()));
        this.setPos(this.getX(), this.getY() + 1.0, this.getZ());
        this.updateStatsToLevel();
        this.spawnMobs(Math.max(1, this.maxNearby - 2));
        this.spawnDelay = this.getRandom().nextInt(MobConfig.minSpawnDelay, MobConfig.maxSpawnDelay);
        if (this.spawnList.isEmpty() && reason != MobSpawnType.SPAWN_EGG && reason != MobSpawnType.COMMAND) {
            this.removeCauseEmptyList = true;
        }
        return spawnData;
    }

    private void updateStatsToLevel() {
        this.getAttribute(Attributes.MAX_HEALTH).removeModifier(ATTRIBUTE_LEVEL_MOD);
        this.getAttribute(Attributes.MAX_HEALTH).addPermanentModifier(new AttributeModifier(ATTRIBUTE_LEVEL_MOD, (double)(this.xpLevel().getLevel() - 1) * MobConfig.gateHealthGain, AttributeModifier.Operation.ADD_VALUE));
        this.getAttribute(RuneCraftoryAttributes.DEFENCE.asHolder()).removeModifier(ATTRIBUTE_LEVEL_MOD);
        this.getAttribute(RuneCraftoryAttributes.DEFENCE.asHolder()).addPermanentModifier(new AttributeModifier(ATTRIBUTE_LEVEL_MOD, (double)(this.xpLevel().getLevel() - 1) * MobConfig.gateDefGain, AttributeModifier.Operation.ADD_VALUE));
        this.getAttribute(RuneCraftoryAttributes.MAGIC_DEFENCE.asHolder()).removeModifier(ATTRIBUTE_LEVEL_MOD);
        this.getAttribute(RuneCraftoryAttributes.MAGIC_DEFENCE.asHolder()).addPermanentModifier(new AttributeModifier(ATTRIBUTE_LEVEL_MOD, (double)(this.xpLevel().getLevel() - 1) * MobConfig.gateMDefGain, AttributeModifier.Operation.ADD_VALUE));
        this.setHealth(this.getMaxHealth());
    }

    public HumanoidArm getMainArm() {
        return HumanoidArm.RIGHT;
    }

    protected float getDamageAfterArmorAbsorb(DamageSource source, float damageAmount) {
        float reduce = 0.0f;
        if (source.is(RunecraftoryTags.DamageTypes.IS_MAGIC)) {
            if (!source.is(RunecraftoryTags.DamageTypes.BYPASS_MAGIC)) {
                reduce = (float)this.getAttributeValue(RuneCraftoryAttributes.MAGIC_DEFENCE.asHolder());
            }
        } else if (!source.is(DamageTypeTags.BYPASSES_ARMOR)) {
            reduce = (float)this.getAttributeValue(RuneCraftoryAttributes.DEFENCE.asHolder());
        }
        float min = reduce > damageAmount * 2.0f ? 0.0f : 0.5f;
        return super.getDamageAfterArmorAbsorb(source, Math.max(min, damageAmount - reduce));
    }

    protected void tickDeath() {
        if (this.deathTime == 5 && !this.level().isClientSide && this.getLastHurtByMob() != null) {
            LevelCalc.addXP(this.getLastHurtByMob(), this.baseXP(), this.baseMoney(), this.xpLevel().getLevel());
        }
        super.tickDeath();
    }

    public void heal(float healAmount) {
    }

    public void knockback(double strength, double x, double z) {
    }

    public boolean isInWall() {
        return false;
    }

    public void push(Entity entity) {
        if (entity instanceof Player) {
            super.push(entity);
        }
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public boolean canBeCollidedWith(Entity other) {
        return other instanceof Player;
    }

    private ItemElement getType(ServerLevelAccessor level, Holder<Biome> key) {
        ItemElement element = ItemElement.values()[this.getRandom().nextInt(ItemElement.values().length)];
        if (key.is(RunecraftoryTags.Biomes.IS_PLAINS) && (double)this.getRandom().nextFloat() < 0.5) {
            element = ItemElement.NONE;
        } else if (key.is(BiomeTags.IS_FOREST) && (double)this.getRandom().nextFloat() < 0.5) {
            element = ItemElement.WIND;
        } else if (key.is(RunecraftoryTags.Biomes.IS_HOT) && (double)this.getRandom().nextFloat() < 0.5) {
            element = ItemElement.FIRE;
        } else if (key.is(BiomeTags.IS_MOUNTAIN) && (double)this.getRandom().nextFloat() < 0.5) {
            element = ItemElement.WIND;
        } else if ((key.is(RunecraftoryTags.Biomes.IS_AQUATIC) || key.is(RunecraftoryTags.Biomes.IS_COLD_OVERWORLD)) && (double)this.getRandom().nextFloat() < 0.5) {
            element = ItemElement.WATER;
        } else if (key.is(RunecraftoryTags.Biomes.IS_SANDY) && (double)this.getRandom().nextFloat() < 0.5) {
            element = ItemElement.EARTH;
        } else if (key.is(RunecraftoryTags.Biomes.IS_MAGICAL)) {
            if ((double)this.getRandom().nextFloat() < 0.4) {
                element = ItemElement.LIGHT;
            } else if ((double)this.getRandom().nextFloat() < 0.2) {
                element = ItemElement.LOVE;
            }
        } else if (key.is(RunecraftoryTags.Biomes.IS_SPOOKY) && (double)this.getRandom().nextFloat() < 0.4) {
            element = ItemElement.DARK;
        }
        if (key.is(BiomeTags.IS_END)) {
            if ((double)this.getRandom().nextFloat() < 0.3) {
                element = ItemElement.DARK;
            } else if ((double)this.getRandom().nextFloat() < 0.3) {
                element = ItemElement.LIGHT;
            }
        }
        return element;
    }

    public boolean broadcastToPlayer(ServerPlayer player) {
        return !this.removeCauseEmptyList;
    }
}

