/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.ai.behaviour.npc;

import com.mojang.datafixers.util.Pair;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.InteractWithDoor;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.object.MemoryTest;
import net.tslat.smartbrainlib.util.BrainUtils;

public class OpenDoors<E extends LivingEntity>
extends ExtendedBehaviour<E> {
    private static final MemoryTest MEMORIES = MemoryTest.builder((int)3).usesMemories(new MemoryModuleType[]{MemoryModuleType.PATH}).usesMemories(new MemoryModuleType[]{MemoryModuleType.DOORS_TO_CLOSE}).usesMemories(new MemoryModuleType[]{MemoryModuleType.NEAREST_LIVING_ENTITIES});

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORIES;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        return super.checkExtraStartConditions(level, entity);
    }

    protected void start(E entity) {
        Path path = (Path)BrainUtils.getMemory(entity, (MemoryModuleType)MemoryModuleType.PATH);
        Set toClose = (Set)BrainUtils.memoryOrDefault(entity, (MemoryModuleType)MemoryModuleType.DOORS_TO_CLOSE, HashSet::new);
        Node previous = null;
        Node next = null;
        if (path != null) {
            GlobalPos res;
            previous = path.getPreviousNode();
            if (previous != null && (res = this.tryOpenDoor(entity, previous.asBlockPos())) != null) {
                toClose.add(res);
            }
            if (!path.isDone() && (res = this.tryOpenDoor(entity, (next = path.getNextNode()).asBlockPos())) != null) {
                toClose.add(res);
            }
        }
        InteractWithDoor.closeDoorsThatIHaveOpenedOrPassedThrough((ServerLevel)((ServerLevel)entity.level()), entity, (Node)previous, (Node)next, (Set)toClose, Optional.ofNullable((List)BrainUtils.getMemory(entity, (MemoryModuleType)MemoryModuleType.NEAREST_LIVING_ENTITIES)));
    }

    protected GlobalPos tryOpenDoor(E entity, BlockPos pos) {
        BlockState state = entity.level().getBlockState(pos);
        if (state.is(BlockTags.MOB_INTERACTABLE_DOORS, s -> s.getBlock() instanceof DoorBlock)) {
            DoorBlock doorBlock = (DoorBlock)state.getBlock();
            if (!doorBlock.isOpen(state)) {
                doorBlock.setOpen(entity, entity.level(), state, pos, true);
            }
            return GlobalPos.of((ResourceKey)entity.level().dimension(), (BlockPos)pos);
        }
        return null;
    }
}

