/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.ai.control;

import io.github.flemmli97.runecraftory.common.utils.MathsHelper;
import java.util.function.BooleanSupplier;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.phys.Vec3;

public class FreeMoveControl
extends MoveControl {
    public static final BooleanSupplier TRUE = () -> true;
    private final BooleanSupplier flying;
    private final float maxYRot;
    private final float maxXRot;

    public FreeMoveControl(Mob mob) {
        this(mob, 90.0f, 30.0f, TRUE);
    }

    public FreeMoveControl(Mob mob, BooleanSupplier flying) {
        this(mob, 90.0f, 30.0f, flying);
    }

    public FreeMoveControl(Mob mob, float maxYRot, float maxXRot, BooleanSupplier flying) {
        super(mob);
        this.maxYRot = maxYRot;
        this.maxXRot = maxXRot;
        this.flying = flying;
    }

    public void tick() {
        if (this.operation == MoveControl.Operation.STRAFE) {
            int z;
            int y;
            int x;
            float speed = (float)(this.speedModifier * this.getSpeedAttribute());
            float forward = this.strafeForwards;
            float right = this.strafeRight;
            float len = Mth.sqrt((float)(forward * forward + right * right));
            if ((double)len < 1.0E-4) {
                return;
            }
            len = speed / len;
            Vec3 target = new Vec3((double)(right *= len), 0.0, (double)(forward *= len)).normalize().scale((double)this.mob.getBbWidth() + 0.3).yRot(-this.mob.getYRot() * ((float)Math.PI / 180));
            PathNavigation pathnavigate = this.mob.getNavigation();
            PathfindingContext ctx = new PathfindingContext((CollisionGetter)this.mob.level(), this.mob);
            NodeEvaluator nodeprocessor = pathnavigate.getNodeEvaluator();
            PathType node = nodeprocessor.getPathType(ctx, x = Mth.floor((double)(this.mob.getX() + target.x())), y = Mth.floor((double)this.mob.getY()), z = Mth.floor((double)(this.mob.getZ() + target.z())));
            if (node != PathType.WALKABLE) {
                this.strafeForwards = 1.0f;
                this.strafeRight = 0.0f;
            }
            this.mob.setSpeed(speed);
            this.mob.setZza(this.strafeForwards);
            this.mob.setXxa(this.strafeRight);
            this.operation = MoveControl.Operation.WAIT;
        } else if (this.operation == MoveControl.Operation.MOVE_TO) {
            this.operation = MoveControl.Operation.WAIT;
            this.mob.setXxa(0.0f);
            Vec3 dir = new Vec3(this.wantedX - this.mob.getX(), this.wantedY - this.mob.getY(), this.wantedZ - this.mob.getZ());
            if (dir.lengthSqr() < 1.0E-4) {
                this.mob.setYya(0.0f);
                this.mob.setZza(0.0f);
                return;
            }
            float[] yXRot = MathsHelper.YXRotFrom(dir);
            this.mob.setYRot(this.rotlerp(this.mob.getYRot(), yXRot[0], this.maxYRot));
            this.mob.setXRot(this.rotlerp(this.mob.getXRot(), yXRot[1], this.maxXRot));
            float speed = (float)(this.speedModifier * this.getSpeedAttribute());
            dir = dir.normalize().scale((double)speed);
            this.mob.setSpeed(speed);
            this.mob.setYya((float)dir.y());
        } else {
            this.mob.setYya(0.0f);
            this.mob.setZza(0.0f);
        }
    }

    protected double getSpeedAttribute() {
        if (this.flying.getAsBoolean()) {
            return this.mob.getAttributeValue(Attributes.FLYING_SPEED);
        }
        return this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED);
    }
}

