/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.ai.goal;

import io.github.flemmli97.runecraftory.common.entities.monster.boss.rafflesia.RafflesiaPart;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import java.util.EnumSet;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class RafflesiaPartAttackGoal
extends Goal {
    protected final RafflesiaPart attacker;
    protected LivingEntity target;
    protected int idleTime;

    public RafflesiaPartAttackGoal(RafflesiaPart entity) {
        this.attacker = entity;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.idleTime = this.attacker.getRandom().nextInt(120) + 20;
    }

    public boolean canUse() {
        LivingEntity living = this.attacker.getTarget();
        return living != null && living.isAlive() && this.attacker.isWithinRestriction(living.blockPosition());
    }

    public boolean canContinueToUse() {
        return this.canUse();
    }

    public void stop() {
        this.target = null;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        if (this.attacker.getTarget() == null) {
            return;
        }
        AnimationState anim = this.attacker.getAnimationHandler().getAnimation();
        if (anim != null) {
            return;
        }
        if (this.idleTime <= 0) {
            this.idleTime = this.attacker.cooldown();
            this.attacker.getAnimationHandler().setAnimation(this.attacker.attackAnim());
        } else {
            --this.idleTime;
        }
    }
}

