/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.items.tools.ItemToolFishingRod;
import io.github.flemmli97.runecraftory.common.lib.LootTableResources;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.mixinhelper.ExtendedFishingRodHookTrigger;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.common.entity.AdvancedProjectile;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.function.BooleanSupplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class CustomFishingHookEntity
extends AdvancedProjectile {
    private static final EntityDataAccessor<Boolean> DATA_BITING = SynchedEntityData.defineId(CustomFishingHookEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private boolean inFishingSpot;
    private boolean inSand;
    private ItemElement element = ItemElement.NONE;
    private FluidState currentFluidState;
    private int nibble;
    private int timeUntilBite;
    private float fishAngle;
    private final int luck;
    private final float lureSpeedBonus;
    private final int nibbleBonus;
    private int difficultyBonus;
    private BooleanSupplier canAttack;
    private Runnable setOnCooldown;

    public CustomFishingHookEntity(EntityType<? extends CustomFishingHookEntity> entityType, Level level) {
        super(entityType, level);
        this.luck = 0;
        this.lureSpeedBonus = 0.0f;
        this.nibbleBonus = 0;
    }

    public CustomFishingHookEntity(Level level, LivingEntity shooter, float speed, int luck, int charge) {
        super((EntityType)RuneCraftoryEntities.FISHING_HOOK.get(), level, shooter);
        this.setPos(this.getX(), this.getY() + 0.1, this.getZ());
        this.shoot((Entity)shooter, Math.max(-90.0f, shooter.getXRot() - 5.0f), shooter.getYRot(), 0.0f, 1.1f + Math.max(-0.3f, Mth.sin((float)(-shooter.getXRot() * ((float)Math.PI / 180)))), 0.0f);
        this.lureSpeedBonus = speed;
        this.luck = luck;
        this.nibbleBonus = charge;
    }

    public void setElement(ItemElement element) {
        this.element = element;
    }

    public void attackHandlingPlayer(BooleanSupplier canAttack, Runnable runnable) {
        this.canAttack = canAttack;
        this.setOnCooldown = runnable;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_BITING, (Object)false);
    }

    public void tick() {
        if (this.shouldStopFishing()) {
            return;
        }
        BlockPos blockPos = this.blockPosition();
        BlockState state = this.level().getBlockState(blockPos);
        BlockState below = this.level().getBlockState(BlockPos.containing((Position)this.position().add(0.0, -0.2, 0.0)));
        this.currentFluidState = this.level().getFluidState(blockPos);
        float fluid = 0.0f;
        this.inSand = false;
        if (this.currentFluidState.is(FluidTags.WATER)) {
            fluid = this.currentFluidState.getHeight((BlockGetter)this.level(), blockPos);
        } else if (state.isAir() && below.is(BlockTags.SAND)) {
            this.inFishingSpot = true;
            this.inSand = true;
        }
        if (!this.inFishingSpot && fluid > 0.0f) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.3, 0.2, 0.3));
            this.inFishingSpot = true;
            return;
        }
        if (this.inFishingSpot) {
            boolean canFish;
            Vec3 vec3 = this.getDeltaMovement();
            double d = this.getY() + vec3.y - (double)blockPos.getY() - (double)fluid;
            if (Math.abs(d) < 0.01) {
                d += Math.signum(d) * 0.1;
            }
            this.setDeltaMovement(vec3.x * 0.9, vec3.y - d * (double)this.random.nextFloat() * 0.2, vec3.z * 0.9);
            boolean bl = canFish = (fluid > 0.0f || this.inSand) && this.correctLocation(blockPos);
            if (canFish) {
                if (((Boolean)this.entityData.get(DATA_BITING)).booleanValue()) {
                    this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.1 * (double)this.random.nextFloat() * (double)this.random.nextFloat(), 0.0));
                }
                if (!this.level().isClientSide) {
                    this.doFishing();
                }
            }
        }
        super.tick();
    }

    public void moveEntity() {
        if (!this.currentFluidState.is(FluidTags.WATER)) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, (double)(-this.getGravityVelocity()), 0.0));
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        this.updateRotation();
        if (!this.inFishingSpot && (this.onGround() || this.horizontalCollision)) {
            this.setDeltaMovement(Vec3.ZERO);
        }
        this.setDeltaMovement(this.getDeltaMovement().scale((double)this.motionReduction(this.isInWater())));
        this.reapplyPosition();
    }

    protected float motionReduction(boolean inWater) {
        return 0.92f;
    }

    public boolean isPiercing() {
        return true;
    }

    public int maxPierceAmount() {
        return 5;
    }

    protected boolean entityRayTraceHit(EntityHitResult entityHitResult) {
        if (this.canAttack != null && !this.canAttack.getAsBoolean()) {
            this.discard();
            return false;
        }
        boolean att = CombatUtils.damageWithFaintAndCrit(this.getOwner(), entityHitResult.getEntity(), new DynamicDamage.Builder((Entity)this, this.getOwner()).noKnockback().element(this.element).hurtResistant(5), CombatUtils.getAttributeValue(this.getOwner(), (Holder<Attribute>)Attributes.ATTACK_DAMAGE), null);
        if (att && this.setOnCooldown != null) {
            this.setOnCooldown.run();
            this.setOnCooldown = null;
            this.canAttack = null;
            Entity entity = this.getOwner();
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                PlayerData data = Platform.INSTANCE.getPlayerData((Player)player);
                LevelCalc.levelSkill(data, Skills.FISHING, 10.0f);
                LevelCalc.levelSkill(data, Skills.WATER, 1.0f);
            }
        }
        return att;
    }

    protected void onBlockHit(BlockHitResult blockHitResult) {
        this.setDeltaMovement(this.getDeltaMovement().normalize().scale(blockHitResult.distanceTo((Entity)this)));
    }

    public boolean canChangeDimensions(Level oldLevel, Level newLevel) {
        return false;
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    public void remove(Entity.RemovalReason reason) {
        super.remove(reason);
        Entity entity = this.getOwner();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            Platform.INSTANCE.getEntityData((LivingEntity)living).fishingHook = null;
        }
    }

    public void onClientRemoval() {
        super.onClientRemoval();
        Entity entity = this.getOwner();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            Platform.INSTANCE.getEntityData((LivingEntity)living).fishingHook = null;
        }
    }

    public void onUpdateOwner() {
        super.onUpdateOwner();
        Entity entity = this.getOwner();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            Platform.INSTANCE.getEntityData((LivingEntity)living).fishingHook = this;
        }
    }

    private boolean shouldStopFishing() {
        Entity entity = this.getOwner();
        if (!(entity instanceof LivingEntity)) {
            return true;
        }
        LivingEntity entity2 = (LivingEntity)entity;
        ItemStack itemStack = entity2.getMainHandItem();
        ItemStack itemStack2 = entity2.getOffhandItem();
        boolean bl = itemStack.getItem() instanceof ItemToolFishingRod;
        boolean bl2 = itemStack2.getItem() instanceof ItemToolFishingRod;
        if (entity2.isRemoved() || !entity2.isAlive() || !bl && !bl2 || this.distanceToSqr((Entity)entity2) > 1024.0) {
            this.discard();
            return true;
        }
        return false;
    }

    private boolean correctLocation(BlockPos blockPos) {
        for (int i = -1; i < 2; ++i) {
            int state = i != 1 ? 0 : 1;
            int yD = this.inSand ? i - 1 : i;
            boolean check = BlockPos.betweenClosedStream((BlockPos)blockPos.offset(-1, yD, -1), (BlockPos)blockPos.offset(1, yD, 1)).allMatch(p -> this.blockCheck((BlockPos)p, state) != LocationType.INVALID);
            if (check) continue;
            return false;
        }
        return true;
    }

    private LocationType blockCheck(BlockPos blockPos, int state) {
        BlockState blockState = this.level().getBlockState(blockPos);
        if (state != 0 && (blockState.isAir() || blockState.is(Blocks.LILY_PAD))) {
            return LocationType.AIR;
        }
        if (this.inSand) {
            if (state != 1 && blockState.is(BlockTags.SAND)) {
                return LocationType.MATCH;
            }
            return LocationType.INVALID;
        }
        FluidState fluidState = blockState.getFluidState();
        if (state != 1 && fluidState.is(FluidTags.WATER) && fluidState.isSource() && blockState.getCollisionShape((BlockGetter)this.level(), blockPos).isEmpty()) {
            return LocationType.MATCH;
        }
        return LocationType.INVALID;
    }

    protected void doFishing() {
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (this.nibble > 0) {
            --this.nibble;
            if (this.nibble <= 0) {
                this.timeUntilBite = 0;
                this.getEntityData().set(DATA_BITING, (Object)false);
            }
        } else if (this.timeUntilBite > 0) {
            --this.timeUntilBite;
            float splashChance = 0.15f;
            if (this.timeUntilBite < 20) {
                splashChance += (float)(20 - this.timeUntilBite) * 0.05f;
            } else if (this.timeUntilBite < 40) {
                splashChance += (float)(40 - this.timeUntilBite) * 0.02f;
            } else if (this.timeUntilBite < 60) {
                splashChance += (float)(60 - this.timeUntilBite) * 0.01f;
            }
            if (this.random.nextFloat() < splashChance) {
                float a = Mth.nextFloat((RandomSource)this.random, (float)0.0f, (float)360.0f) * ((float)Math.PI / 180);
                float c = Mth.nextFloat((RandomSource)this.random, (float)25.0f, (float)60.0f);
                double x = this.getX() + (double)(Mth.sin((float)a) * c) * 0.1;
                double y = (float)Mth.floor((double)this.getY()) + 1.0f;
                double z = this.getZ() + (double)(Mth.cos((float)a) * c) * 0.1;
                if (this.inSand) {
                    Vec3 belowPos = this.position().add(0.0, -0.2, 0.0);
                    BlockState below = this.level().getBlockState(BlockPos.containing((double)x, (double)belowPos.y, (double)z));
                    if (below.is(BlockTags.SAND)) {
                        serverLevel.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, below), x, y - 0.9, z, 2 + this.random.nextInt(2), (double)0.1f, 0.0, (double)0.1f, 0.0);
                    }
                } else if (serverLevel.getBlockState(BlockPos.containing((double)x, (double)(y - 1.0), (double)z)).is(Blocks.WATER)) {
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.SPLASH, x, y, z, 2 + this.random.nextInt(2), (double)0.1f, 0.0, (double)0.1f, 0.0);
                }
            }
            if (this.timeUntilBite > 0) {
                this.fishAngle = (float)((double)this.fishAngle + this.random.nextGaussian() * 4.0);
                float angle = this.fishAngle * ((float)Math.PI / 180);
                float g = Mth.sin((float)angle);
                float h = Mth.cos((float)angle);
                double y = (float)Mth.floor((double)this.getY()) + 1.0f;
                double z = this.getZ() + (double)(h * (float)this.timeUntilBite * 0.1f);
                double x = this.getX() + (double)(g * (float)this.timeUntilBite * 0.1f);
                if (this.inSand) {
                    y -= 1.0;
                }
                BlockState blockState = serverLevel.getBlockState(BlockPos.containing((double)x, (double)(y - 1.0), (double)z));
                if (this.inSand && blockState.is(Blocks.SAND) || !this.inSand && blockState.is(Blocks.WATER)) {
                    SimpleParticleType bubble = ParticleTypes.BUBBLE;
                    SimpleParticleType particle = ParticleTypes.BUBBLE;
                    if (this.inSand) {
                        particle = bubble = new BlockParticleOption(ParticleTypes.BLOCK, blockState);
                        y += 0.1;
                    }
                    if (this.random.nextFloat() < 0.15f) {
                        serverLevel.sendParticles((ParticleOptions)bubble, x, y - (double)0.1f, z, 1, (double)g, 0.1, (double)h, 0.0);
                    }
                    float k = g * 0.04f;
                    float l = h * 0.04f;
                    serverLevel.sendParticles((ParticleOptions)particle, x, y, z, 0, (double)l, 0.01, (double)(-k), 1.0);
                    serverLevel.sendParticles((ParticleOptions)particle, x, y, z, 0, (double)(-l), 0.01, (double)k, 1.0);
                }
            } else {
                this.playSound(SoundEvents.FISHING_BOBBER_SPLASH, 0.25f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
                double m = this.getY() + 0.5;
                SimpleParticleType particle = ParticleTypes.BUBBLE;
                if (this.inSand) {
                    BlockState below = this.level().getBlockState(BlockPos.containing((Position)this.position().add(0.0, -0.2, 0.0)));
                    particle = new BlockParticleOption(ParticleTypes.BLOCK, below);
                }
                serverLevel.sendParticles((ParticleOptions)particle, this.getX(), m, this.getZ(), (int)(1.0f + this.getBbWidth() * 20.0f), (double)this.getBbWidth(), 0.0, (double)this.getBbWidth(), (double)0.2f);
                if (!this.inSand) {
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.FISHING, this.getX(), m, this.getZ(), (int)(1.0f + this.getBbWidth() * 20.0f), (double)this.getBbWidth(), 0.0, (double)this.getBbWidth(), (double)0.2f);
                }
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.NOTE, this.getX(), m, this.getZ(), 0, 0.0, 0.0, 0.0, 0.0);
                this.difficultyBonus = Mth.nextInt((RandomSource)this.random, (int)0, (int)3);
                this.nibble = Mth.nextInt((RandomSource)this.random, (int)12, (int)(30 - this.difficultyBonus * 3)) - this.difficultyBonus * 5;
                this.nibble += this.nibbleBonus * 3;
                this.nibble = Math.max(1, this.nibble);
                this.getEntityData().set(DATA_BITING, (Object)true);
            }
        } else {
            this.fishAngle = Mth.nextFloat((RandomSource)this.random, (float)0.0f, (float)360.0f);
            this.timeUntilBite = Mth.nextInt((RandomSource)this.random, (int)((int)Math.max(5.0f, 100.0f - this.lureSpeedBonus * 15.0f)), (int)((int)Math.max(50.0f, 600.0f - this.lureSpeedBonus * 75.0f)));
        }
    }

    public void retract(ItemStack stack) {
        Entity eOwner = this.getOwner();
        if (this.level().isClientSide || this.shouldStopFishing()) {
            return;
        }
        if (!(eOwner instanceof ServerPlayer)) {
            this.discard();
            return;
        }
        ServerPlayer owner = (ServerPlayer)eOwner;
        if (this.nibble > 0) {
            Entity itemStack22;
            float luck = (float)this.luck + owner.getLuck() + (float)this.difficultyBonus * 0.5f + (float)Platform.INSTANCE.getPlayerData((Player)owner).getSkillLevel(Skills.FISHING).getLevel() * 0.02f;
            LootParams.Builder builder = new LootParams.Builder((ServerLevel)this.level()).withParameter(LootContextParams.ORIGIN, (Object)this.position()).withParameter(LootContextParams.TOOL, (Object)stack).withParameter(LootContextParams.THIS_ENTITY, (Object)this).withLuck(luck);
            ResourceKey<LootTable> loot = this.inSand ? LootTableResources.SAND_FISHING : LootTableResources.FISHING;
            LootTable lootTable = this.level().getServer().reloadableRegistries().getLootTable(loot);
            ObjectArrayList list = lootTable.getRandomItems(builder.create(LootContextParamSets.FISHING));
            ((ExtendedFishingRodHookTrigger)CriteriaTriggers.FISHING_ROD_HOOKED).runecraftory$customTrigger(owner, stack, this, (Collection<ItemStack>)list);
            for (Entity itemStack22 : list) {
                ItemEntity itemEntity = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), (ItemStack)itemStack22);
                double d = owner.getX() - this.getX();
                double e = owner.getY() - this.getY();
                double f = owner.getZ() - this.getZ();
                itemEntity.setDeltaMovement(d * 0.1, e * 0.1 + Math.sqrt(Math.sqrt(d * d + e * e + f * f)) * 0.08, f * 0.1);
                this.level().addFreshEntity((Entity)itemEntity);
                owner.level().addFreshEntity((Entity)new ExperienceOrb(owner.level(), owner.getX(), owner.getY() + 0.5, owner.getZ() + 0.5, this.random.nextInt(6) + 1));
                if (!itemStack22.is(ItemTags.FISHES)) continue;
                owner.awardStat(Stats.FISH_CAUGHT, 1);
            }
            itemStack22 = this.getOwner();
            if (itemStack22 instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)itemStack22;
                PlayerData data = Platform.INSTANCE.getPlayerData((Player)player);
                LevelCalc.useRP(data, 10 * (this.nibbleBonus + 1), true, 0.0f, true, Skills.FISHING);
                LevelCalc.levelSkill(data, Skills.FISHING, 25.0f);
                LevelCalc.levelSkill(data, Skills.WATER, 5.0f);
            }
        }
        this.discard();
    }

    static enum LocationType {
        AIR,
        MATCH,
        INVALID;

    }
}

