/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseBeam;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;

public class DarkBeamEntity
extends BaseBeam {
    public DarkBeamEntity(EntityType<? extends DarkBeamEntity> type, Level level) {
        super(type, level);
    }

    public DarkBeamEntity(Level level, LivingEntity shooter) {
        super((EntityType<? extends BaseBeam>)((EntityType)RuneCraftoryEntities.DARK_BEAM.get()), level, shooter);
    }

    public float getRange() {
        return 14.0f;
    }

    public float radius() {
        return 0.5f;
    }

    public boolean piercing() {
        return true;
    }

    public int livingTickMax() {
        return 25;
    }

    public void onImpact(EntityHitResult res) {
        CombatUtils.damageWithFaintAndCrit(this.getOwner(), res.getEntity(), new DynamicDamage.Builder((Entity)this, this.getOwner()).magic().noKnockback().hurtResistant(10).element(ItemElement.DARK), CombatUtils.getAttributeValue(this.getOwner(), (Holder<Attribute>)RuneCraftoryAttributes.MAGIC_ATTACK.asHolder()) * (double)this.damageMultiplier, null);
    }

    public boolean canStartDamage() {
        return this.livingTicks == 1;
    }
}

