/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseDamageCloud;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.tenshilib.common.entity.EntityUtils;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class HomingEnergyOrbEntity
extends BaseDamageCloud
implements PowerableMob {
    private Vec3 spawnPos;
    private LivingEntity targetMob;
    protected static final EntityDataAccessor<Optional<UUID>> TARGET_UUID = SynchedEntityData.defineId(HomingEnergyOrbEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);

    public HomingEnergyOrbEntity(EntityType<? extends BaseDamageCloud> type, Level level) {
        super(type, level);
        this.setRadius(0.5f);
    }

    public HomingEnergyOrbEntity(Level level, LivingEntity shooter) {
        super((EntityType<? extends BaseDamageCloud>)((EntityType)RuneCraftoryEntities.ENERGY_ORB.get()), level, shooter);
        this.setPos(this.getX(), this.getY() + (double)shooter.getBbHeight() * 0.5, this.getZ());
        this.setRadius(0.5f);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TARGET_UUID, Optional.empty());
    }

    public int livingTickMax() {
        return 100;
    }

    protected boolean damageEntity(LivingEntity target) {
        return CombatUtils.damageWithFaintAndCrit(this.getOwner(), (Entity)target, new DynamicDamage.Builder((Entity)this, this.getOwner()).damageType(DynamicDamage.DamageCategory.IGNOREMAGICDEF).noKnockback().hurtResistant(7).element(ItemElement.LIGHT), CombatUtils.getAttributeValue(this.getOwner(), (Holder<Attribute>)RuneCraftoryAttributes.MAGIC_ATTACK.asHolder()) * (double)this.damageMultiplier, null);
    }

    public void tick() {
        super.tick();
        Vec3 motion = this.getDeltaMovement();
        double newX = this.getX() + motion.x;
        double newY = this.getY() + motion.y;
        double newZ = this.getZ() + motion.z;
        this.setPos(newX, newY, newZ);
        if (this.spawnPos == null) {
            this.spawnPos = this.position().add(0.0, (double)this.getBbHeight() * 0.5, 0.0);
        }
        if (!this.level().isClientSide) {
            if (this.getTargetMob() == null || this.getTargetMob().isDeadOrDying()) {
                this.targetMob = io.github.flemmli97.runecraftory.common.utils.EntityUtils.ownedProjectileTarget(this.getOwner(), 16);
                if (this.targetMob != null) {
                    this.entityData.set(TARGET_UUID, Optional.of(this.targetMob.getUUID()));
                } else {
                    this.entityData.set(TARGET_UUID, Optional.empty());
                }
            } else {
                Vec3 dir;
                Vec3 root = this.rootPosition(1.0f);
                Vec3 dirTarget = this.getTargetMob().position().add(0.0, (double)this.getTargetMob().getBbHeight() * 0.5, 0.0).subtract(root);
                if (dirTarget.lengthSqr() > 225.0) {
                    dirTarget = dirTarget.normalize().scale(15.0);
                }
                if ((dir = root.add(dirTarget).subtract(this.position())).lengthSqr() > 0.10890000000000001) {
                    dir = dir.normalize().scale(0.33);
                }
                this.setDeltaMovement(dir);
                this.hasImpulse = true;
            }
        } else if (this.random.nextBoolean()) {
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), (SoundEvent)RuneCraftorySounds.ENTITY_ENERGY_ORB_AMBIENT.get(), this.getSoundSource(), 2.0f, 0.8f, false);
        }
    }

    public LivingEntity getTargetMob() {
        if (this.targetMob != null && !this.targetMob.isRemoved()) {
            return this.targetMob;
        }
        ((Optional)this.entityData.get(TARGET_UUID)).ifPresent(uuid -> {
            this.targetMob = (LivingEntity)EntityUtils.findFromUUID(LivingEntity.class, (Level)this.level(), (UUID)uuid);
        });
        return this.targetMob;
    }

    public Vec3 rootPosition(float partialTicks) {
        if (this.getOwner() != null) {
            Entity owner = this.getOwner();
            double x = Mth.lerp((double)partialTicks, (double)owner.xOld, (double)owner.getX());
            double y = Mth.lerp((double)partialTicks, (double)owner.yOld, (double)owner.getY()) + (double)owner.getBbHeight() * 0.5;
            double z = Mth.lerp((double)partialTicks, (double)owner.zOld, (double)owner.getZ());
            return new Vec3(x, y, z);
        }
        return this.spawnPos;
    }

    public boolean isPowered() {
        return true;
    }
}

