/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseProjectile;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryParticles;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleContainer;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleData;
import io.github.flemmli97.tenshilib.common.particle.data.ColorData;
import io.github.flemmli97.tenshilib.common.particle.data.MotionData;
import io.github.flemmli97.tenshilib.common.particle.data.ParticleMetaData;
import io.github.flemmli97.tenshilib.common.particle.data.ScaleData;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class PowerWaveEntity
extends BaseProjectile {
    private final List<UUID> attackedEntities = new ArrayList<UUID>();

    public PowerWaveEntity(EntityType<? extends PowerWaveEntity> type, Level level) {
        super(type, level);
    }

    public PowerWaveEntity(Level level, LivingEntity shooter) {
        super((EntityType<? extends BaseProjectile>)((EntityType)RuneCraftoryEntities.POWER_WAVE.get()), level, shooter);
    }

    public int livingTickMax() {
        return 15;
    }

    protected float getGravityVelocity() {
        return 0.0f;
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            for (int i = 0; i < 4; ++i) {
                AdvancedParticleContainer.make((ParticleOptions)((ParticleOptions)RuneCraftoryParticles.LIGHT.get())).addData((AdvancedParticleData)new ColorData(0.8117647f, 0.7607843f, 0.23529412f, 0.5f)).addData((AdvancedParticleData)new MotionData(0.0, 0.15 + this.random.nextGaussian() * 0.03, 0.0)).addData((AdvancedParticleData)new ScaleData((float)(0.4 + this.random.nextGaussian() * 0.2))).addData((AdvancedParticleData)new ParticleMetaData(20, false, 0.0f)).add(this.level(), this.getX() + this.random.nextGaussian() * 0.15, this.getY(), this.getZ() + this.random.nextGaussian() * 0.15);
            }
        } else {
            List targets = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(0.5).expandTowards(0.0, 1.5, 0.0), this::canHit);
            for (LivingEntity living : targets) {
                this.checkedEntities.add(living.getUUID());
                if (this.attackedEntities.contains(living.getUUID()) || !CombatUtils.damageWithFaintAndCrit(this.getOwner(), (Entity)living, new DynamicDamage.Builder((Entity)this, this.getOwner()).noKnockback().hurtResistant(4), CombatUtils.getAttributeValue(this.getOwner(), (Holder<Attribute>)Attributes.ATTACK_DAMAGE) * (double)this.damageMultiplier, null)) continue;
                this.attackedEntities.add(living.getUUID());
            }
        }
    }

    protected boolean entityRayTraceHit(EntityHitResult result) {
        return CombatUtils.damageWithFaintAndCrit(this.getOwner(), result.getEntity(), new DynamicDamage.Builder((Entity)this, this.getOwner()).noKnockback().hurtResistant(4), CombatUtils.getAttributeValue(this.getOwner(), (Holder<Attribute>)Attributes.ATTACK_DAMAGE) * (double)this.damageMultiplier, null);
    }

    protected void onBlockHit(BlockHitResult result) {
    }
}

