/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseBeam;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;

public class RockSpearEntity
extends BaseBeam {
    private static final EntityDataAccessor<Boolean> BIG = SynchedEntityData.defineId(RockSpearEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public RockSpearEntity(EntityType<? extends RockSpearEntity> type, Level level) {
        super(type, level);
    }

    public RockSpearEntity(Level level, LivingEntity shooter, boolean big) {
        super((EntityType<? extends BaseBeam>)((EntityType)RuneCraftoryEntities.ROCK_SPEAR.get()), level, shooter);
        this.setPos(this.getX(), this.getY() - 0.1, this.getZ());
        this.entityData.set(BIG, (Object)big);
    }

    public boolean bigRock() {
        return (Boolean)this.entityData.get(BIG);
    }

    public float getRange() {
        return this.bigRock() ? 6.0f : 4.0f;
    }

    public float radius() {
        return this.bigRock() ? 0.8f : 0.5f;
    }

    public boolean piercing() {
        return true;
    }

    public int livingTickMax() {
        return 15;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(BIG, (Object)false);
    }

    public void onImpact(EntityHitResult entityHitResult) {
        CombatUtils.damageWithFaintAndCrit(this.getOwner(), entityHitResult.getEntity(), new DynamicDamage.Builder((Entity)this, this.getOwner()).magic().noKnockback().element(ItemElement.EARTH).hurtResistant(5), CombatUtils.getAttributeValue(this.getOwner(), (Holder<Attribute>)RuneCraftoryAttributes.MAGIC_ATTACK.asHolder()) * (double)this.damageMultiplier, null);
    }

    public boolean canStartDamage() {
        return this.livingTicks - 1 == 5;
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.entityData.set(BIG, (Object)compound.getBoolean("BigRock"));
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("BigRock", this.bigRock());
    }
}

