/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryParticles;
import io.github.flemmli97.runecraftory.common.utils.WorldUtils;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleContainer;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleData;
import io.github.flemmli97.tenshilib.common.particle.data.ColorData;
import io.github.flemmli97.tenshilib.common.particle.data.MotionData;
import io.github.flemmli97.tenshilib.common.particle.data.ParticleMetaData;
import io.github.flemmli97.tenshilib.common.particle.data.ScaleData;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class SarcophagusTeleporter
extends Entity {
    private int spawnedDay;

    public SarcophagusTeleporter(EntityType<?> entityType, Level level) {
        super(entityType, level);
        if (!level.isClientSide) {
            this.spawnedDay = WorldUtils.day(level);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.spawnedDay = compound.getInt("SpawnedDay");
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putInt("SpawnedDay", this.spawnedDay);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            if (this.random.nextInt(3) == 0) {
                AdvancedParticleContainer.make((ParticleOptions)((ParticleOptions)RuneCraftoryParticles.LIGHT.get())).addData((AdvancedParticleData)new ColorData(0.19215687f, 0.40392157f, 0.7411765f)).addData((AdvancedParticleData)new MotionData(this.random.nextGaussian() * 0.02, Math.abs(this.random.nextGaussian() * 0.02), this.random.nextGaussian() * 0.02)).addData((AdvancedParticleData)new ScaleData(0.4f)).addData((AdvancedParticleData)new ParticleMetaData(10, false, 0.0f)).add(this.level(), this.getX(), this.getY() + (double)this.getBbHeight() * 0.5, this.getZ());
            }
        } else {
            int day = WorldUtils.day(this.level());
            if (this.spawnedDay != day) {
                this.discard();
            }
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            this.discard();
            return true;
        }
        return super.hurt(source, amount);
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        if (!player.level().isClientSide && hand == InteractionHand.MAIN_HAND) {
            player.displayClientMessage((Component)Component.translatable((String)"runecraftory.misc.sarcophagus.coming.soon").withStyle(ChatFormatting.DARK_RED), false);
        }
        return super.interact(player, hand);
    }

    public boolean isPickable() {
        return true;
    }
}

