/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseDamageCloud;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleContainer;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleData;
import io.github.flemmli97.tenshilib.common.particle.data.MotionData;
import io.github.flemmli97.tenshilib.common.particle.data.ParticleMetaData;
import io.github.flemmli97.tenshilib.common.particle.data.ScaleData;
import io.github.flemmli97.tenshilib.common.utils.math.MathUtils;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.joml.Vector3f;

public class SporeEntity
extends BaseDamageCloud {
    private static final List<Vector3f> PARTICLE_CIRCLE = MathUtils.rotatedVecs((Vector3f)new Vector3f(0.025f, 0.065f, 0.0f), (Vector3f)new Vector3f(0.0f, 1.0f, 0.0f), (float)-180.0f, (float)160.0f, (float)20.0f);

    public SporeEntity(EntityType<? extends SporeEntity> type, Level level) {
        super(type, level);
    }

    public SporeEntity(Level level, LivingEntity shooter) {
        super((EntityType<? extends BaseDamageCloud>)((EntityType)RuneCraftoryEntities.SPORE.get()), level, shooter);
    }

    public int maxHitCount() {
        return 1;
    }

    public int livingTickMax() {
        return 20;
    }

    public boolean canStartDamage() {
        return this.livingTicks > 4;
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide && this.livingTicks == 1) {
            this.level().broadcastEntityEvent((Entity)this, (byte)64);
        }
    }

    protected boolean damageEntity(LivingEntity livingEntity) {
        return CombatUtils.damageWithFaintAndCrit(this.getOwner(), (Entity)livingEntity, new DynamicDamage.Builder((Entity)this, this.getOwner()).element(ItemElement.EARTH).magic().noKnockback().hurtResistant(5), CombatUtils.getAttributeValue(this.getOwner(), (Holder<Attribute>)RuneCraftoryAttributes.MAGIC_ATTACK.asHolder()) * (double)this.damageMultiplier, null);
    }

    protected AABB damageBoundingBox() {
        return super.damageBoundingBox().inflate(0.2, 0.5, 0.2);
    }

    public void handleEntityEvent(byte id) {
        if (id == 64) {
            for (Vector3f dir : PARTICLE_CIRCLE) {
                for (int i = 0; i < 3; ++i) {
                    AdvancedParticleContainer.make((ParticleOptions)new DustParticleOptions(new Vector3f(0.65882355f, 0.8901961f, 0.3372549f), 1.0f)).addData((AdvancedParticleData)new ScaleData(0.25f)).addData((AdvancedParticleData)new MotionData((double)(dir.x() * 3.0f), (double)dir.y(), (double)(dir.z() * 3.0f))).addData((AdvancedParticleData)new ParticleMetaData(15, true, 0.2f)).add(this.level(), this.getX(), this.getY() + (double)this.getBbHeight() * 0.3, this.getZ());
                }
            }
        } else {
            super.handleEntityEvent(id);
        }
    }
}

