/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseProjectile;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryParticles;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleContainer;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleData;
import io.github.flemmli97.tenshilib.common.particle.data.ColorData;
import io.github.flemmli97.tenshilib.common.particle.data.MotionData;
import io.github.flemmli97.tenshilib.common.particle.data.ParticleMetaData;
import io.github.flemmli97.tenshilib.common.particle.data.ScaleData;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class ThiccLightningBoltEntity
extends BaseProjectile {
    public ThiccLightningBoltEntity(EntityType<? extends ThiccLightningBoltEntity> type, Level level) {
        super(type, level);
    }

    public ThiccLightningBoltEntity(Level level, LivingEntity shooter) {
        super((EntityType<? extends BaseProjectile>)((EntityType)RuneCraftoryEntities.LIGHTNING_ORB_BOLT.get()), level, shooter);
    }

    public boolean isPiercing() {
        return true;
    }

    public float radius() {
        return 1.0f;
    }

    public int livingTickMax() {
        return 70;
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            int i;
            for (i = 0; i < 3; ++i) {
                AdvancedParticleContainer.make((ParticleOptions)((ParticleOptions)RuneCraftoryParticles.LIGHT.get())).addData((AdvancedParticleData)new ColorData(0.14901961f, 0.52156866f, 0.87058824f, 0.8f)).addData((AdvancedParticleData)new MotionData(this.random.nextGaussian() * 0.01, Math.abs(this.random.nextGaussian() * 0.03), this.random.nextGaussian() * 0.01)).addData((AdvancedParticleData)new ScaleData(0.25f)).addData((AdvancedParticleData)new ParticleMetaData(20, false, 0.0f)).add(this.level(), this.getRandomX(0.5), this.getY(this.getRandom().nextDouble() * 0.5) + (double)this.getBbHeight() * 0.4, this.getRandomZ(0.5));
            }
            for (i = 0; i < 8; ++i) {
                AdvancedParticleContainer.make((ParticleOptions)((ParticleOptions)RuneCraftoryParticles.LIGHTNING.get())).addData((AdvancedParticleData)new MotionData(this.getRandom().nextGaussian() * 0.03, Math.abs(this.getRandom().nextGaussian() * 0.05), this.getRandom().nextGaussian() * 0.03)).add(this.level(), this.getRandomX(0.5), this.getY(this.getRandom().nextDouble() * 0.5) + (double)this.getBbHeight() * 0.4, this.getRandomZ(0.5));
            }
        } else if (this.livingTicks % 13 == 0) {
            this.checkedEntities.clear();
            this.attackedEntities.clear();
        }
    }

    protected float getGravityVelocity() {
        return 0.0f;
    }

    protected boolean entityRayTraceHit(EntityHitResult result) {
        return CombatUtils.damageWithFaintAndCrit(this.getOwner(), result.getEntity(), new DynamicDamage.Builder((Entity)this, this.getOwner()).magic().noKnockback().hurtResistant(4).element(ItemElement.WIND), CombatUtils.getAttributeValue(this.getOwner(), (Holder<Attribute>)RuneCraftoryAttributes.MAGIC_ATTACK.asHolder()) * (double)this.damageMultiplier, null);
    }

    protected void onBlockHit(BlockHitResult blockRayTraceResult) {
        this.discard();
    }
}

