/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseBeam;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryParticles;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleContainer;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleData;
import io.github.flemmli97.tenshilib.common.particle.data.ColorData;
import io.github.flemmli97.tenshilib.common.particle.data.MotionData;
import io.github.flemmli97.tenshilib.common.particle.data.ParticleMetaData;
import io.github.flemmli97.tenshilib.common.particle.data.ScaleData;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class ThunderboltBeamEntity
extends BaseBeam {
    public ThunderboltBeamEntity(EntityType<? extends ThunderboltBeamEntity> type, Level level) {
        super(type, level);
    }

    public ThunderboltBeamEntity(Level level, LivingEntity shooter) {
        super((EntityType<? extends BaseBeam>)((EntityType)RuneCraftoryEntities.LIGHTNING_BEAM.get()), level, shooter);
    }

    public float getRange() {
        return 14.0f;
    }

    public float radius() {
        return 0.4f;
    }

    public boolean piercing() {
        return true;
    }

    public int livingTickMax() {
        return 25;
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            Vec3 pos = this.position();
            Vec3 dir = this.hitVec.subtract(pos);
            for (double d = 0.0; d < 1.0; d += 0.025) {
                Vec3 scaleD = dir.scale(d).add(pos);
                AdvancedParticleContainer.make((ParticleOptions)((ParticleOptions)RuneCraftoryParticles.LIGHT.get())).addData((AdvancedParticleData)new ColorData(0.13333334f, 0.13333334f, 0.7058824f, 0.6f)).addData((AdvancedParticleData)new ScaleData(0.2f)).addData((AdvancedParticleData)new ParticleMetaData(10, false, 0.0f)).add(this.level(), scaleD.x(), scaleD.y(), scaleD.z());
                AdvancedParticleContainer.make((ParticleOptions)((ParticleOptions)RuneCraftoryParticles.LIGHTNING.get())).addData((AdvancedParticleData)new MotionData(this.getRandom().nextGaussian() * 0.03, this.getRandom().nextGaussian() * 0.03, this.getRandom().nextGaussian() * 0.03)).add(this.level(), scaleD.x() + (this.random.nextDouble() - 0.5) * 0.1, scaleD.y() + (this.random.nextDouble() - 0.5) * 0.1, scaleD.z() + (this.random.nextDouble() - 0.5) * 0.1);
            }
        }
    }

    public void onImpact(EntityHitResult res) {
        CombatUtils.damageWithFaintAndCrit(this.getOwner(), res.getEntity(), new DynamicDamage.Builder((Entity)this, this.getOwner()).magic().noKnockback().hurtResistant(10).element(ItemElement.WIND), CombatUtils.getAttributeValue(this.getOwner(), (Holder<Attribute>)RuneCraftoryAttributes.MAGIC_ATTACK.asHolder()) * (double)this.damageMultiplier, null);
    }

    public boolean canStartDamage() {
        return this.livingTicks == 1;
    }
}

