/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.runecraftory.common.items.creative.TreasureChestSpawnegg;
import io.github.flemmli97.runecraftory.common.lib.LootTableResources;
import io.github.flemmli97.runecraftory.common.loot.LootCtxParameters;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimatedEntity;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import io.github.flemmli97.tenshilib.common.item.SpawnEgg;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class TreasureChestEntity
extends Entity
implements AnimatedEntity {
    public static final int MAX_TIER = 4;
    private static final EntityDataAccessor<Integer> TIER = SynchedEntityData.defineId(TreasureChestEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String OPEN = BUILDER.add("open", AnimationsBuilder.definition((double)0.32).infinite());
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private final AnimationHandler<TreasureChestEntity> animationHandler = new AnimationHandler((Entity)this, ANIMS);
    protected Player lastHurtByPlayer;
    private ResourceKey<LootTable> chestLoot;
    private Runnable openChest;

    public TreasureChestEntity(EntityType<? extends TreasureChestEntity> entityType, Level level) {
        super(entityType, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(TIER, (Object)0);
    }

    public void baseTick() {
        super.baseTick();
        this.getAnimationHandler().tick();
        AnimationState anim = this.getAnimationHandler().getAnimation();
        if (!this.isRemoved() && !this.level().isClientSide && anim != null && anim.is(new String[]{OPEN}) && anim.done(0)) {
            if (this.openChest != null) {
                this.openChest.run();
            }
            this.discard();
        }
        if (!this.isNoGravity()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.04, 0.0));
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        double friction = 0.98;
        if (this.onGround()) {
            friction = this.level().getBlockState(BlockPos.containing((double)this.getX(), (double)(this.getY() - 1.0), (double)this.getZ())).getBlock().getFriction() * 0.98f;
        }
        this.setDeltaMovement(this.getDeltaMovement().multiply(friction, 0.98, friction));
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.tier() == TreasureChestSpawnegg.ChestTier.EPIC && !source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return false;
        }
        Entity entity = source.getEntity();
        if (entity instanceof Player) {
            Player player;
            this.lastHurtByPlayer = player = (Player)entity;
        }
        if (!this.level().isClientSide) {
            this.discard();
            this.dropFromLootTable(source, true);
        }
        for (int i = 0; i < 20; ++i) {
            double d0 = this.random.nextGaussian() * 0.02;
            double d1 = this.random.nextGaussian() * 0.02;
            double d2 = this.random.nextGaussian() * 0.02;
            this.level().addParticle((ParticleOptions)ParticleTypes.POOF, this.getRandomX(1.0), this.getRandomY(), this.getRandomZ(1.0), d0, d1, d2);
        }
        return true;
    }

    public boolean isPickable() {
        return true;
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.setTier(TreasureChestSpawnegg.ChestTier.values()[compound.getInt("ChestTier")]);
        if (compound.contains("ChestLoot")) {
            this.chestLoot = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.parse((String)compound.getString("ChestLoot")));
        }
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putInt("ChestTier", ((Integer)this.entityData.get(TIER)).intValue());
        if (this.chestLoot != null) {
            compound.putString("ChestLoot", this.chestLoot.location().toString());
        }
    }

    public void setChestLoot(ResourceKey<LootTable> loot) {
        this.chestLoot = loot;
        this.setTier(TreasureChestSpawnegg.ChestTier.EPIC);
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!this.getAnimationHandler().isCurrent(new String[]{OPEN})) {
                this.getAnimationHandler().setAnimation(OPEN);
                this.playSound(SoundEvents.CHEST_OPEN, 0.7f, 1.0f);
                this.openChest = () -> this.openChest(serverPlayer, serverPlayer.getItemInHand(hand));
                LevelCalc.levelSkill(Platform.INSTANCE.getPlayerData(player), Skills.SEARCHING, 20.0f);
            }
        }
        return InteractionResult.CONSUME;
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public ItemStack getPickResult() {
        return SpawnEgg.fromType((EntityType)this.getType()).map(ItemStack::new).orElse(ItemStack.EMPTY);
    }

    public void setTier(TreasureChestSpawnegg.ChestTier tier) {
        this.entityData.set(TIER, (Object)tier.ordinal());
    }

    public TreasureChestSpawnegg.ChestTier tier() {
        return TreasureChestSpawnegg.ChestTier.values()[(Integer)this.entityData.get(TIER)];
    }

    protected void openChest(ServerPlayer player, ItemStack stack) {
        ResourceKey<LootTable> resourceKey;
        if (this.chestLoot != null) {
            resourceKey = this.chestLoot;
        } else {
            switch (this.tier()) {
                case UNCOMMON: {
                    resourceKey = LootTableResources.TIER_2_LOOT;
                    break;
                }
                case RARE: {
                    resourceKey = LootTableResources.TIER_3_LOOT;
                    break;
                }
                case EPIC: {
                    resourceKey = LootTableResources.TIER_4_LOOT;
                    break;
                }
                default: {
                    resourceKey = LootTableResources.TIER_1_LOOT;
                }
            }
        }
        ResourceKey<LootTable> tableKey = resourceKey;
        LootParams.Builder builder = new LootParams.Builder((ServerLevel)this.level()).withLuck(player.getLuck()).withParameter(LootContextParams.THIS_ENTITY, (Object)this).withParameter(LootContextParams.ORIGIN, (Object)this.position()).withParameter(LootCtxParameters.UUID_CONTEXT, (Object)player.getUUID()).withParameter(LootContextParams.TOOL, (Object)stack);
        LootTable lootTable = this.level().getServer().reloadableRegistries().getLootTable(tableKey);
        lootTable.getRandomItems(builder.create(LootCtxParameters.MONSTER_INTERACTION), arg_0 -> ((TreasureChestEntity)this).spawnAtLocation(arg_0));
    }

    protected void dropFromLootTable(DamageSource damageSource, boolean attackedRecently) {
        ResourceKey tableKey = this.getType().getDefaultLootTable();
        LootTable lootTable = this.level().getServer().reloadableRegistries().getLootTable(tableKey);
        LootParams.Builder builder = this.createLootContext(attackedRecently, damageSource);
        lootTable.getRandomItems(builder.create(LootContextParamSets.ENTITY), arg_0 -> ((TreasureChestEntity)this).spawnAtLocation(arg_0));
    }

    protected LootParams.Builder createLootContext(boolean attackedRecently, DamageSource damageSource) {
        LootParams.Builder builder = new LootParams.Builder((ServerLevel)this.level()).withParameter(LootContextParams.THIS_ENTITY, (Object)this).withParameter(LootContextParams.ORIGIN, (Object)this.position()).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)damageSource).withOptionalParameter(LootContextParams.ATTACKING_ENTITY, (Object)damageSource.getEntity()).withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)damageSource.getDirectEntity());
        if (attackedRecently && this.lastHurtByPlayer != null) {
            builder = builder.withParameter(LootContextParams.LAST_DAMAGE_PLAYER, (Object)this.lastHurtByPlayer).withLuck(this.lastHurtByPlayer.getLuck());
        }
        return builder;
    }

    public AnimationHandler<?> getAnimationHandler() {
        return this.animationHandler;
    }
}

