/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc.summoners;

import io.github.flemmli97.runecraftory.common.entities.misc.ButterflyEntity;
import io.github.flemmli97.runecraftory.common.entities.misc.ProjectileSummonHelperEntity;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class ButterflySummonerEntity
extends ProjectileSummonHelperEntity {
    public ButterflySummonerEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public ButterflySummonerEntity(Level level, LivingEntity caster) {
        super((EntityType)RuneCraftoryEntities.BUTTERFLY_SUMMONER.get(), level, caster);
        this.maxLivingTicks = 26;
    }

    @Override
    protected void summonProjectiles() {
        ButterflyEntity fly = new ButterflyEntity(this.level(), this.getOwner());
        fly.setDamageMultiplier(this.damageMultiplier);
        fly.setPos(fly.getX() + (double)(this.random.nextFloat() * 2.0f) - 1.0, fly.getY() + (double)this.random.nextFloat() * 0.05 - 0.1, fly.getZ() + (double)(this.random.nextFloat() * 2.0f) - 1.0);
        fly.shootAtPosition(this.targetX, this.targetY, this.targetZ, 0.3f, 12.0f);
        this.playSound((SoundEvent)RuneCraftorySounds.SPELL_GENERIC_POP.get(), 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
        this.level().addFreshEntity((Entity)fly);
    }
}

