/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ChargingMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.SetChargeTarget;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;

public class Buffamoo
extends ChargingMonster {
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String CHARGE_ATTACK = BUILDER.add("charge", AnimationsBuilder.definition((double)2.2).marker("attack_start", new double[]{0.72}).marker("attack_end", new double[]{1.92}));
    public static final String STOMP = BUILDER.add("stomp", AnimationsBuilder.definition((double)0.48).marker("attack", new double[]{0.28}));
    public static final String INTERACT = BUILDER.add("interact", STOMP);
    public static final String SLEEP = BUILDER.add("sleep", AnimationsBuilder.definition((double)0.0).infinite());
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private final AnimationHandler<Buffamoo> animationHandler = new AnimationHandler((Entity)this, ANIMS);

    public Buffamoo(EntityType<? extends Buffamoo> type, Level level) {
        super((EntityType<? extends ChargingMonster>)type, level);
    }

    @Override
    protected void applyAttributes() {
        this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.2);
        super.applyAttributes();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(new String[]{STOMP}).play(MonsterBehaviourUtils.requireInRangePlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(4).start(new String[]{CHARGE_ATTACK}).play(MonsterBehaviourUtils.cooldownedPlay()).prepare(new ExtendedBehaviour[]{new SetChargeTarget()}).end(2).start(new String[]{CHARGE_ATTACK}).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifFurtherThan(4.0)).prepare(new ExtendedBehaviour[]{new SetChargeTarget()}).end(3).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(2, new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(MonsterBehaviourUtils.closeEnough(5)), MonsterBehaviourUtils.moveTo()}).add(2, MonsterBehaviourUtils.ifCloserThan(7.0), new ExtendedBehaviour[]{new SetRandomWalkTarget(), MonsterBehaviourUtils.moveTo()}).add(3, MonsterBehaviourUtils.withCondition(MonsterBehaviourUtils.ifCloserThan(9.0)), new ExtendedBehaviour[]{new Idle()}).build();
    }

    @Override
    public AABB attackBB(AnimationState anim) {
        double width = (double)this.getBbWidth() * 1.4;
        double length = (double)this.getBbWidth() * 1.8;
        return new AABB(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.getBbHeight() + 0.02, length);
    }

    @Override
    public DynamicDamage.Builder damageSourceAttack() {
        DynamicDamage.Builder source = super.damageSourceAttack();
        if (this.getAnimationHandler().isCurrent(new String[]{CHARGE_ATTACK})) {
            source.knock(DynamicDamage.KnockBackType.BACK, 2.0f);
        } else if (this.getAnimationHandler().isCurrent(new String[]{STOMP})) {
            source.withChangedAttribute((Holder<Attribute>)RuneCraftoryAttributes.STUN.asHolder(), 20.0);
        }
        return source;
    }

    public AnimationHandler<Buffamoo> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    protected boolean isChargingAnim(String anim) {
        return anim.equals(CHARGE_ATTACK);
    }

    @Override
    public double chargingSpeed() {
        return 0.35;
    }

    @Override
    public void doWhileCharge() {
        if (this.tickCount % 3 == 0) {
            this.level().playSound(null, this.blockPosition(), (SoundEvent)RuneCraftorySounds.ENTITY_BUFFAMOO_STEP.get(), this.getSoundSource(), 1.0f, 0.9f + this.getRandom().nextFloat() * 0.2f);
        }
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, (Entity)this.getControllingPassenger(), null)) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(CHARGE_ATTACK);
            } else {
                this.getAnimationHandler().setAnimation(STOMP);
            }
        }
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)RuneCraftorySounds.ENTITY_BUFFAMOO_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)RuneCraftorySounds.ENTITY_BUFFAMOO_DEATH.get();
    }

    public float getVoicePitch() {
        return 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f;
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }

    @Override
    public String getSleepAnimation() {
        return SLEEP;
    }
}

